/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.servlet.resource;

import jakarta.servlet.ServletException;
import java.util.List;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anosite.content.servlet.resource.ResourceServlet;
import net.anotheria.anosite.content.servlet.resource.type.ResourceReadType;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;

public class CMSImageServlet
extends ResourceServlet {
    @Override
    protected String getFileName(ResourceReadType type, String propertyValue) throws ServletException {
        if (type == ResourceReadType.BY_DIRECT_FILE_NAME) {
            return propertyValue;
        }
        switch (type) {
            case BY_ID: {
                try {
                    Image image = this.getResourceService().getImage(propertyValue);
                    if (image != null) {
                        return image.getImage();
                    }
                    CMSImageServlet.getLog().warn("Image " + type.getValue() + "[" + propertyValue + "] ::: missing");
                    return null;
                }
                catch (NoSuchDocumentException nSde) {
                    CMSImageServlet.getLog().warn("Image " + type.getValue() + "[" + propertyValue + "] ::: missing");
                    return null;
                }
                catch (ASResourceDataServiceException e) {
                    CMSImageServlet.getLog().error("ASResourceDataServiceException failed", (Throwable)e);
                    throw new ServletException("Internal Server Error", (Throwable)e);
                }
            }
            case BY_NAME: {
                try {
                    List images = this.getResourceService().getImagesByProperty("name", (Object)propertyValue);
                    if (images != null && !images.isEmpty() && images.get(0) != null) {
                        return ((Image)images.get(0)).getImage();
                    }
                    CMSImageServlet.getLog().warn("Image " + type.getValue() + "[" + propertyValue + "] ::: missing");
                    return null;
                }
                catch (ASResourceDataServiceException e) {
                    CMSImageServlet.getLog().error("ASResourceDataServiceException failed", (Throwable)e);
                    throw new ServletException("Internal Server Error", (Throwable)e);
                }
            }
        }
        throw new RuntimeException(type + " NOT supported!");
    }
}

