/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.servlet.resource;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.content.servlet.resource.ResourceServletUtils;
import net.anotheria.anosite.content.servlet.resource.type.ResourceReadType;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.anosite.shared.ResourceServletMappingConfig;
import net.anotheria.moskito.web.MoskitoHttpServlet;
import net.anotheria.util.StringUtils;
import net.anotheria.webutils.filehandling.actions.FileStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceServlet
extends MoskitoHttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServlet.class);
    private static final ResourceServletMappingConfig config = ResourceServletMappingConfig.getInstance();
    private IASResourceDataService resourceService;

    public ResourceServlet() {
        try {
            this.resourceService = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException e) {
            LOG.error("ResourceServlet init failure", (Throwable)e);
            throw new RuntimeException("ResourceServlet init failure", e);
        }
    }

    protected void moskitoDoGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String[] params = ResourceServletUtils.parsePathParameters(req);
        if (params == null || params.length == 0) {
            String message = "Illegal parameters!";
            LOG.info("moskitoDoGet(req, resp) fail. " + message);
            res.setStatus(400);
            return;
        }
        LOG.debug("Params[" + params + "].");
        if (params.length == 1) {
            if (StringUtils.isEmpty((String)params[0])) {
                String message = "Illegal parameters!";
                LOG.info("moskitoDoGet(req, resp) fail. " + message);
                res.setStatus(400);
                return;
            }
            try {
                File file = FileStorage.getFile((String)params[0]);
                ResourceServletUtils.streamFile(res, file);
            }
            catch (IOException e) {
                res.sendError(404, "File " + params[0] + " not found! Probably deleted on disk. PATH = " + req.getPathInfo());
            }
            return;
        }
        if (params.length >= 2) {
            String fileName;
            if (StringUtils.isEmpty((String)params[0]) || StringUtils.isEmpty((String)params[1])) {
                String message = "Illegal parameters!";
                LOG.info("moskitoDoGet(req, resp) fail. " + message);
                res.setStatus(400);
                return;
            }
            ResourceReadType type = ResourceReadType.getByValue(params[0]);
            String string = fileName = type != ResourceReadType.BY_DIRECT_FILE_NAME ? this.getFileName(type, params[1]) : params[1];
            if (StringUtils.isEmpty((String)fileName)) {
                res.sendError(404, "File " + type.getValue() + "[" + params[1] + "] not found. PATH = " + req.getPathInfo());
                return;
            }
            try {
                File file = FileStorage.getFile((String)fileName);
                ResourceServletUtils.streamFile(res, file);
            }
            catch (IOException e) {
                res.sendError(404, "Resource " + fileName + " not found! Probably deleted on disk. PATH = " + req.getPathInfo());
            }
        }
    }

    protected abstract String getFileName(ResourceReadType var1, String var2) throws ServletException;

    public static Logger getLog() {
        return LOG;
    }

    public IASResourceDataService getResourceService() {
        return this.resourceService;
    }

    protected void moskitoDoPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.sendError(403, "Forbidden");
    }
}

