/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.servlet.resource;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.anotheria.util.IOUtils;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResourceServletUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServletUtils.class);
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static Map<String, String> extensionMapping = new HashMap<String, String>();

    protected static String[] parsePathParameters(HttpServletRequest request) {
        return request.getPathInfo().substring(1).split("/");
    }

    protected static void streamFile(HttpServletResponse response, File file) throws IOException {
        response.setContentType(ResourceServletUtils.guessMimeType(file.getName()));
        response.setContentLength((int)file.length());
        response.setHeader(LAST_MODIFIED_HEADER, new Date(file.lastModified()).toGMTString());
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            org.apache.commons.io.IOUtils.copyLarge((InputStream)in, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            try {
                LOG.error("streamFile[response, " + file + "] failed", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeIgnoringException(in);
                throw throwable;
            }
        }
        IOUtils.closeIgnoringException((Closeable)in);
    }

    private static String guessMimeType(String fName) {
        if (!StringUtils.isEmpty((String)fName)) {
            String extension;
            String string = extension = fName.contains(".") && fName.lastIndexOf(".") != fName.length() - 1 ? fName.substring(fName.lastIndexOf(46) + 1) : null;
            if (extension != null) {
                return extensionMapping.get(extension);
            }
        }
        return null;
    }

    private ResourceServletUtils() {
        throw new IllegalAccessError("Can't be instantiated");
    }

    static {
        extensionMapping.put("pdf", "application/pdf");
        extensionMapping.put("jpe", "image/jpeg");
        extensionMapping.put("jpeg", "image/jpeg");
        extensionMapping.put("jpg", "image/jpeg");
        extensionMapping.put("png", "image/png");
        extensionMapping.put("js", "text/javascript");
        extensionMapping.put("exe", "application/octet-stream");
        extensionMapping.put("gif", "image/gif");
        extensionMapping.put("gz", "application/x-gzip");
        extensionMapping.put("zip", "application/zip");
        extensionMapping.put("doc", "application/msword");
        extensionMapping.put("dot", "application/msword");
        extensionMapping.put("pot", "application/vnd.ms-powerpoint");
        extensionMapping.put("ppt", "application/vnd.ms-powerpoint");
        extensionMapping.put("pps", "application/vnd.ms-powerpoint");
    }
}

