/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.variables;

import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anodoc.util.context.BrandConfig;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anoplass.api.APICallContext;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.content.bean.AttributeBean;
import net.anotheria.anosite.content.bean.AttributeMap;
import net.anotheria.anosite.content.variables.VariablesProcessor;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class AttributeProcessor
implements VariablesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeProcessor.class);
    private static IASWebDataService iasWebDataService;

    @Override
    public String replace(String prefix, String variable, String defValue, HttpServletRequest req) {
        BrandConfig brandConfig;
        AttributeBean bean;
        Object ret = null;
        if ("NONE".equals(defValue)) {
            defValue = "";
        }
        if (prefix.equals("api_cca")) {
            ret = APICallContext.getCallContext().getAttribute(variable);
        }
        if (prefix.equals("api_sa")) {
            ret = APICallContext.getCallContext().getCurrentSession().getAttribute(variable);
        }
        if (prefix.equals("ra")) {
            ret = req.getAttribute(variable);
        }
        if (prefix.equals("sa")) {
            ret = req.getSession().getAttribute(variable);
        }
        if (prefix.equals("sda")) {
            ret = req.getSession().getAttribute(variable);
            req.getSession().removeAttribute(variable);
        }
        if (prefix.equals("ca")) {
            ret = req.getSession().getServletContext().getAttribute(variable);
        }
        if ("ba".equals(prefix)) {
            bean = ((AttributeMap)APICallContext.getCallContext().getAttribute(AttributeMap.BOX_ATTRIBUTES_CALL_CONTEXT_SCOPE_NAME)).getAttribute(variable);
            Object object = ret = bean == null ? null : bean.getValue();
        }
        if ("pa".equals(prefix)) {
            bean = ((AttributeMap)APICallContext.getCallContext().getAttribute(AttributeMap.PAGE_ATTRIBUTES_CALL_CONTEXT_SCOPE_NAME)).getAttribute(variable);
            Object object = ret = bean == null ? null : bean.getValue();
        }
        if ("b_a".equals(prefix) && (brandConfig = ContextManager.getCallContext().getBrandConfig()) != null) {
            for (String attrId : brandConfig.getAttributes()) {
                try {
                    Attribute attribute = iasWebDataService.getAttribute(attrId);
                    if (!attribute.getKey().equals(variable)) continue;
                    ret = attribute.getValue();
                    break;
                }
                catch (ASWebDataServiceException e) {
                    LOGGER.warn("Unable to check attribute with id [{}] for brand.{}", (Object)attrId, (Object)e.getMessage());
                }
            }
        }
        return ret == null ? defValue : ret.toString();
    }

    static {
        try {
            iasWebDataService = (IASWebDataService)MetaFactory.get(IASWebDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "IASWebDataService init failure", (Throwable)e);
        }
    }
}

