/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.variables;

import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.content.variables.CalendarVariableNames;
import net.anotheria.anosite.content.variables.VariablesProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarProcessor
implements VariablesProcessor {
    private static final Logger log = LoggerFactory.getLogger(CalendarProcessor.class);

    @Override
    public String replace(String prefix, String variable, String defValue, HttpServletRequest req) {
        try {
            CalendarVariableNames variableName = CalendarVariableNames.valueOf(CalendarVariableNames.class, variable);
            return variableName.getVariableValue(defValue);
        }
        catch (NullPointerException e) {
            log.error("Exception has been occured while trying to use CallendarProcessor replace method", (Throwable)e);
            log.debug("incoming variable = " + variable);
            return "Variable can't be null";
        }
        catch (IllegalArgumentException e) {
            log.error("Exception has been occured while trying to use CallendarProcessor replace method", (Throwable)e);
            log.debug("incoming variable = " + variable);
            return "Wrong or unsupported variable";
        }
    }
}

