/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.variables;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.anotheria.anoplass.api.APICallContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CalendarVariableNames {
    currentDate("currentDate", "yyyy.MM.dd  HH:mm:ss"){

        @Override
        List<String> getAllowedFormats() {
            return null;
        }
    }
    ,
    currentDay("currentDay", "dd"){

        @Override
        List<String> getAllowedFormats() {
            return 2.getAllowedDayFormats();
        }
    }
    ,
    currentMonth("currentMonth", "MMMM"){

        @Override
        List<String> getAllowedFormats() {
            return 3.getAllowedMonthFormats();
        }
    }
    ,
    currentYear("currentYear", "yyyy"){

        @Override
        List<String> getAllowedFormats() {
            return 4.getAllowedYearFormats();
        }
    }
    ,
    currentTime("currentTime", "HH:mm:ss"){

        @Override
        List<String> getAllowedFormats() {
            return 5.getAllowedTimeFormats();
        }
    };

    private static final Logger log;
    private static List<String> allowedDayFormats;
    private static List<String> allowedMonthFormats;
    private static List<String> allowedYearFormats;
    private static List<String> allowedTimeFormats;
    private final String variableName;
    private final String defaultFormatPattern;

    private CalendarVariableNames(String name, String format) {
        this.variableName = name;
        this.defaultFormatPattern = format;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getDefaultFormatPattern() {
        return this.defaultFormatPattern;
    }

    public String getVariableValue(String format) {
        SimpleDateFormat dateFormat;
        format = this.isFormatValid(format) ? format : this.defaultFormatPattern;
        try {
            dateFormat = new SimpleDateFormat(format, APICallContext.getCallContext().getCurrentLocale());
        }
        catch (IllegalArgumentException e) {
            log.error("Unsupported DateFormat pattern - " + format + " used for variable - " + this.getVariableName());
            dateFormat = new SimpleDateFormat(this.defaultFormatPattern);
        }
        return dateFormat.format(new Date());
    }

    private boolean isFormatValid(String format) {
        if (this.getAllowedFormats() == null || Collections.EMPTY_LIST.equals(this.getAllowedFormats())) {
            return !CalendarVariableNames.isBlankOrNull(format);
        }
        return !CalendarVariableNames.isBlankOrNull(format) && this.getAllowedFormats().contains(format);
    }

    private static boolean isBlankOrNull(String str) {
        return str == null || "".equals(str);
    }

    public static List<String> getAllowedMonthFormats() {
        return allowedMonthFormats;
    }

    public static List<String> getAllowedTimeFormats() {
        return allowedTimeFormats;
    }

    public static List<String> getAllowedYearFormats() {
        return allowedYearFormats;
    }

    public static List<String> getAllowedDayFormats() {
        return allowedDayFormats;
    }

    abstract List<String> getAllowedFormats();

    static {
        log = LoggerFactory.getLogger(CalendarVariableNames.class);
        allowedDayFormats = new ArrayList<String>();
        allowedDayFormats.add("dd");
        allowedDayFormats.add("d");
        allowedMonthFormats = new ArrayList<String>();
        allowedMonthFormats.add("MMMMM");
        allowedMonthFormats.add("MMMM");
        allowedMonthFormats.add("MMM");
        allowedMonthFormats.add("MM");
        allowedMonthFormats.add("M");
        allowedYearFormats = new ArrayList<String>();
        allowedYearFormats.add("yyyy");
        allowedYearFormats.add("yyy");
        allowedYearFormats.add("yy");
        allowedYearFormats.add("y");
        allowedTimeFormats = new ArrayList<String>();
        allowedTimeFormats.add("HH:mm:ss");
        allowedTimeFormats.add("HH:mm");
        allowedTimeFormats.add("HH:mm:ss, Z");
        allowedTimeFormats.add("h:mm a");
        allowedTimeFormats.add("hh:mm a");
        allowedTimeFormats.add("hh:mm a, Z");
    }
}

