/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.variables;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.content.variables.ImageLinkProcessor;
import net.anotheria.anosite.content.variables.VariablesProcessor;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.anosite.shared.ResourceServletMappingConfig;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class ImageProcessor
implements VariablesProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ImageProcessor.class);
    private static IASResourceDataService service;
    private static ResourceServletMappingConfig mappingConfig;
    private static final String SEPARATOR_STRING = "/";

    @Override
    public String replace(String prefix, String variable, String defValue, HttpServletRequest req) {
        if (StringUtils.isEmpty((String)variable)) {
            LOG.debug("Invalid incoming parameter! Variable!");
            return null;
        }
        try {
            List imgList = service.getImagesByProperty("name", (Object)variable);
            if (imgList == null || imgList.isEmpty()) {
                LOG.debug("Image with name " + variable + " not found!");
                return null;
            }
            Image img = (Image)imgList.get(0);
            if (img == null) {
                return null;
            }
            String filePath = mappingConfig.getImageServletMapping() + img.getImage();
            if (!req.getContextPath().isEmpty()) {
                filePath = req.getContextPath() + filePath;
            }
            String alt = img.getAlt();
            String title = img.getTitle();
            if (alt.isEmpty()) {
                return "<img src=\"" + filePath + "\" alt=\"" + title + "\" border=\"0\"/>";
            }
            return "<img src=\"" + filePath + "\" alt=\"" + alt + "\" border=\"0\"/>";
        }
        catch (ASResourceDataServiceException e) {
            LOG.error("ASResourceDataServiceException failed", (Throwable)e);
            return null;
        }
    }

    static {
        mappingConfig = ResourceServletMappingConfig.getInstance();
        try {
            service = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException e) {
            LoggerFactory.getLogger(ImageLinkProcessor.class).error(MarkerFactory.getMarker((String)"FATAL"), "Not properly initialized, can't find resource data service.");
        }
    }
}

