/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.variables;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import net.anotheria.anoplass.api.APICallContext;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.content.variables.VariablesProcessor;
import net.anotheria.anosite.gen.asresourcedata.data.TextResource;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.anosite.localization.LocalizationMap;
import net.anotheria.anosite.tags.content.BaseResourceTag;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class LocalizationProcessor
implements VariablesProcessor {
    private static final Logger TEXT_RESOURCE_LOGGER = LoggerFactory.getLogger((String)"TextResourceLog");
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseResourceTag.class);
    public static final String PREFIX = "mes";
    private static IASResourceDataService service;

    @Override
    public String replace(String prefix, String variable, String defValue, HttpServletRequest req) {
        if (PREFIX.equals(prefix) && !StringUtils.isEmpty((String)variable)) {
            TEXT_RESOURCE_LOGGER.info(variable);
            String value = this.getLocalizationFromMap(variable);
            if (value != null) {
                return value;
            }
            value = this.getLocalizationFromResources(variable);
            return value != null ? value : "Missing translation: " + variable;
        }
        return defValue;
    }

    protected String getLocalizationFromMap(String key) {
        LocalizationMap localization = (LocalizationMap)APICallContext.getCallContext().getAttribute(LocalizationMap.CALL_CONTEXT_SCOPE_NAME);
        return localization.getMessage(key);
    }

    protected String getLocalizationFromResources(String key) {
        try {
            List resources = service.getTextResourcesByProperty("name", (Object)key);
            if (resources == null || resources.size() == 0) {
                return null;
            }
            return ((TextResource)resources.get(0)).getValue();
        }
        catch (ASGRuntimeException e) {
            LOGGER.error("getLocalizationFromResources(" + key + ")", (Throwable)e);
            return null;
        }
    }

    static {
        try {
            service = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "IASResourceDataService init failure", (Throwable)e);
        }
    }
}

