/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.variables;

import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.config.StaticResourceServerNameConfig;
import net.anotheria.anosite.content.variables.VariablesProcessor;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticResourceServerNameProcessor
implements VariablesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticResourceServerNameProcessor.class);
    public static final String PREFIX = "static";

    @Override
    public String replace(String prefix, String variable, String defValue, HttpServletRequest req) {
        if (StringUtils.isEmpty((String)variable)) {
            LOGGER.error("StaticResourceServerNameProcessor - replace method: Error! Missing key: " + variable + " in server " + req.getServerName() + " on page: " + req.getRequestURI());
            return null;
        }
        return this.getCorrectPathToStaticResource(variable);
    }

    private String getCorrectPathToStaticResource(String resource) {
        String serverName = StaticResourceServerNameConfig.getInstance().getNameResourceServer();
        return serverName == null ? resource : serverName + resource;
    }
}

