/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.variables;

import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.content.variables.VariablesProcessor;
import net.anotheria.anosite.content.variables.helper.TextResourceProcessorHelper;
import net.anotheria.anosite.gen.asresourcedata.data.TextResource;
import net.anotheria.asg.exception.ASGRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextResourceProcessor
implements VariablesProcessor {
    private final Logger log = LoggerFactory.getLogger(TextResourceProcessor.class);
    public static final String PREFIX = "text";
    private static final String ERROR_MESSAGE = "Wrong or unsupported variable : ";

    @Override
    public String replace(String prefix, String variable, String defValue, HttpServletRequest req) {
        try {
            TextResource resource = TextResourceProcessorHelper.getTextResourceByName(variable);
            if (resource == null) {
                this.log.error("TextResourceProcessor - replace method: Error! Missing key: " + variable + " in server " + req.getServerName() + " on page: " + req.getRequestURI());
                return ERROR_MESSAGE + variable;
            }
            return resource.getValue();
        }
        catch (ASGRuntimeException e) {
            this.log.error("TextResourceProcessor - replace method: Error! Missing key: " + variable + " in server " + req.getServerName() + " on page: " + req.getRequestURI(), (Throwable)e);
            return ERROR_MESSAGE + variable;
        }
    }
}

