/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.variables;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.anosite.content.variables.AttributeProcessor;
import net.anotheria.anosite.content.variables.CalendarProcessor;
import net.anotheria.anosite.content.variables.ConditionProcessor;
import net.anotheria.anosite.content.variables.ConstantsProcessor;
import net.anotheria.anosite.content.variables.FileLinkProcessor;
import net.anotheria.anosite.content.variables.ImageLinkProcessor;
import net.anotheria.anosite.content.variables.ImageProcessor;
import net.anotheria.anosite.content.variables.LocalizationBundleVariableProcessor;
import net.anotheria.anosite.content.variables.LocalizationProcessor;
import net.anotheria.anosite.content.variables.ParameterProcessor;
import net.anotheria.anosite.content.variables.StaticResourceServerNameProcessor;
import net.anotheria.anosite.content.variables.TextResourceProcessor;
import net.anotheria.anosite.content.variables.VariablesProcessor;
import net.anotheria.util.StringUtils;
import net.anotheria.util.content.element.ContentElement;
import net.anotheria.util.content.element.DynamicElement;
import net.anotheria.util.content.element.StaticElement;

public class VariablesUtility {
    private static final Map<String, VariablesProcessor> defaultProcessors = new HashMap<String, VariablesProcessor>();
    private static final Map<String, LocalizationBundleVariableProcessor> lbProcessors = new HashMap<String, LocalizationBundleVariableProcessor>();

    public static void addProcessor(String prefix, VariablesProcessor processor) {
        defaultProcessors.put(prefix, processor);
    }

    public static void addLocalizationBundleProcessor(String variable, LocalizationBundleVariableProcessor processor) {
        lbProcessors.put(variable, processor);
    }

    public static String replaceLocalizationBundleVariables(String source) {
        if (StringUtils.isEmpty((String)source)) {
            return source;
        }
        for (String key : lbProcessors.keySet()) {
            if (!source.contains(key)) continue;
            source = source.replace(key, lbProcessors.get(key).replace(key));
        }
        return source;
    }

    public static Map<String, VariablesProcessor> getDefaultProcessors() {
        HashMap<String, VariablesProcessor> ret = new HashMap<String, VariablesProcessor>();
        ret.putAll(defaultProcessors);
        return ret;
    }

    public static String replaceVariables(HttpServletRequest req, String src) {
        return VariablesUtility.replaceVariables(req, src, defaultProcessors);
    }

    public static String replaceVariables(HttpServletRequest req, String src, Map<String, VariablesProcessor> processors) {
        if (src == null || src.length() == 0) {
            return src;
        }
        List<ContentElement> index = VariablesUtility.indexSource(src);
        return VariablesUtility.replaceVariables(req, index, processors);
    }

    public static String replaceVariables(HttpServletRequest req, List<ContentElement> index, Map<String, VariablesProcessor> processors) {
        StringBuilder ret = new StringBuilder();
        for (ContentElement el : index) {
            ret.append(VariablesUtility.replaceContentElement(req, el, processors));
        }
        return ret.toString();
    }

    public static List<ContentElement> indexSource(String src) {
        String myS = StringUtils.removeChar((String)src, (char)'\r');
        List stringIndex = StringUtils.indexSuperTags((String)myS, (char)'{', (char)'}');
        ArrayList<ContentElement> ret = new ArrayList<ContentElement>(stringIndex.size());
        for (String s : stringIndex) {
            ret.add(VariablesUtility.createContentElementInDynamic(s, '{', '}'));
        }
        return ret;
    }

    private static ContentElement createContentElementInDynamic(String elementText, char dynamicTagStart, char dynamicTagEnd) {
        if (elementText.charAt(0) != dynamicTagStart) {
            return new StaticElement(elementText);
        }
        String varName = StringUtils.strip((String)elementText, (int)1, (int)1);
        char c = varName.charAt(0);
        if (c == '\t' || c == ' ' || c == '\n' || c == '\r') {
            return new StaticElement(elementText);
        }
        if (varName != null && varName.startsWith("\"") && varName.endsWith("\"")) {
            return new StaticElement(StringUtils.strip((String)varName, (int)1, (int)1));
        }
        List tokens = StringUtils.tokenize((String)varName, (char)'{', (char)'}', (char[])new char[]{':'});
        if (tokens.size() < 2) {
            return new StaticElement("Wrong format \"" + varName + "\" expected: {prefix:varname[:default value]}");
        }
        String prefix = (String)tokens.get(0);
        String var = (String)tokens.get(1);
        String defaultValue = tokens.size() > 2 ? (String)tokens.get(2) : "";
        List<ContentElement> varIndex = VariablesUtility.indexSource(var);
        List<ContentElement> defValueIndex = VariablesUtility.indexSource(defaultValue);
        return new DynamicElement(elementText, prefix, varIndex, defValueIndex);
    }

    private static String replaceContentElement(HttpServletRequest req, ContentElement contentElement, Map<String, VariablesProcessor> processors) {
        if (!contentElement.isDynamic()) {
            return contentElement.getElementText();
        }
        DynamicElement dynIndex = (DynamicElement)contentElement;
        String prefix = dynIndex.getPrefix();
        String var = VariablesUtility.replaceVariables(req, dynIndex.getVariableIndex(), processors);
        String defaultValue = VariablesUtility.replaceVariables(req, dynIndex.getDefValueIndex(), processors);
        VariablesProcessor processor = processors.get(prefix);
        if (processor == null) {
            return dynIndex.getElementText();
        }
        return processor.replace(prefix, var, defaultValue, req);
    }

    static {
        defaultProcessors.put("cal", new CalendarProcessor());
        defaultProcessors.put("c", new ConstantsProcessor());
        defaultProcessors.put("p", new ParameterProcessor());
        VariablesProcessor p = new AttributeProcessor();
        defaultProcessors.put("ra", p);
        defaultProcessors.put("sa", p);
        defaultProcessors.put("ca", p);
        defaultProcessors.put("api_cca", p);
        defaultProcessors.put("api_sa", p);
        defaultProcessors.put("ba", p);
        defaultProcessors.put("pa", p);
        defaultProcessors.put("b_a", p);
        defaultProcessors.put("mes", new LocalizationProcessor());
        defaultProcessors.put("imagelink", new ImageLinkProcessor());
        defaultProcessors.put("filelink", new FileLinkProcessor());
        defaultProcessors.put("image", new ImageProcessor());
        p = new ConditionProcessor();
        defaultProcessors.put("if", p);
        defaultProcessors.put("ifNot", p);
        defaultProcessors.put("present", p);
        defaultProcessors.put("notPresent", p);
        defaultProcessors.put("equals", p);
        defaultProcessors.put("notEquals", p);
        defaultProcessors.put("inRange", p);
        defaultProcessors.put("greaterThan", p);
        defaultProcessors.put("greaterEqual", p);
        defaultProcessors.put("lessThan", p);
        defaultProcessors.put("lessEqual", p);
        defaultProcessors.put("text", new TextResourceProcessor());
        defaultProcessors.put("static", new StaticResourceServerNameProcessor());
    }
}

