/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.decorator;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.util.StringUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class AttributeCMS2Decorator
implements IAttributeDecorator {
    private static IASWebDataService service;

    public String decorate(DataObject doc, String attributeName, String rule) {
        try {
            ArrayList links = null;
            try {
                links = ((Document)doc).getListProperty(attributeName).getListData();
            }
            catch (NoSuchPropertyException e) {
                links = new ArrayList(0);
            }
            ArrayList<CallSite> ids = new ArrayList<CallSite>(links.size());
            String value = links.size() + " [";
            Object linksValue = "";
            for (Object l : links) {
                if (((String)linksValue).length() > 0) {
                    linksValue = (String)linksValue + ", ";
                }
                linksValue = (String)linksValue + l;
                ids.add((CallSite)((Object)("" + l)));
            }
            value = value + (String)linksValue + "]";
            Object href = "#";
            if (doc instanceof Pagex) {
                href = "pagex" + StringUtils.capitalize((String)attributeName) + "Show?ownerId=" + doc.getId() + "&pId=" + doc.getId() + "&ts=" + System.currentTimeMillis();
            }
            if (doc instanceof Box) {
                href = "aswebdataBoxAttributesShow?ownerId=" + doc.getId() + "&pId=" + doc.getId() + "&ts=" + System.currentTimeMillis();
            }
            Object title = "";
            for (String string : ids) {
                Object name;
                try {
                    name = service.getAttribute(string).getName();
                }
                catch (NoSuchDocumentException e) {
                    name = "*DELETED*";
                }
                catch (ASWebDataServiceException e) {
                    name = "*ERR-" + e.getMessage() + "*";
                }
                if (((String)title).length() > 0) {
                    title = (String)title + ", ";
                }
                title = (String)title + (String)name;
            }
            if (((String)title).length() > 0) {
                title = " title=\"" + (String)title + "\"";
            }
            return "<a href=\"" + (String)href + "\"" + (String)title + ">" + value + "</a>";
        }
        catch (NoSuchPropertyException e) {
            return "none";
        }
    }

    static {
        try {
            service = (IASWebDataService)MetaFactory.get(IASWebDataService.class);
        }
        catch (MetaFactoryException e) {
            LoggerFactory.getLogger(AttributeCMS2Decorator.class).error(MarkerFactory.getMarker((String)"FATAL"), "IASWebDataService asg service init failure", (Throwable)e);
        }
    }
}

