/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.decorator;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.util.StringUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class BoxDecorator
implements IAttributeDecorator {
    private static IASWebDataService service;

    public String decorate(DataObject doc, String attributeName, String rule) {
        try {
            ArrayList links = null;
            try {
                links = ((Document)doc).getListProperty(attributeName).getListData();
            }
            catch (NoSuchPropertyException e) {
                links = new ArrayList(0);
            }
            ArrayList<CallSite> ids = new ArrayList<CallSite>(links.size());
            String value = links.size() + " [";
            Object linksValue = "";
            for (Object l : links) {
                if (((String)linksValue).length() > 0) {
                    linksValue = (String)linksValue + ", ";
                }
                linksValue = (String)linksValue + l;
                ids.add((CallSite)((Object)("" + l)));
            }
            value = value + (String)linksValue + "]";
            Object href = "#";
            if (doc instanceof Pagex) {
                href = doc.getDefinedParentName().toLowerCase() + StringUtils.capitalize((String)doc.getDefinedName()) + StringUtils.capitalize((String)attributeName) + "Show?pId=" + doc.getId() + "&ownerId=" + doc.getId() + "&ts=" + System.currentTimeMillis();
            }
            if (doc instanceof Box) {
                href = doc.getDefinedParentName().toLowerCase() + "BoxSubboxesShow?pId=" + doc.getId() + "&ownerId=" + doc.getId() + "&ts=" + System.currentTimeMillis();
            }
            Object title = "";
            for (String string : ids) {
                Object name;
                try {
                    name = service.getBox(string).getName();
                }
                catch (NoSuchDocumentException e) {
                    name = "*DELETED*";
                }
                catch (ASGRuntimeException e) {
                    name = "*ASG-ERR: " + e.getMessage() + "*";
                }
                if (((String)title).length() > 0) {
                    title = (String)title + ", ";
                }
                title = (String)title + (String)name;
            }
            if (((String)title).length() > 0) {
                title = " title=\"" + (String)title + "\"";
            }
            String hrefTarget = ((String)href).length() > 1 ? " target=\"_blank\"" : "";
            return "<a href=\"" + (String)href + "\"" + hrefTarget + (String)title + ">" + value + "</a>";
        }
        catch (NoSuchPropertyException e) {
            return "none";
        }
    }

    static {
        try {
            service = (IASWebDataService)MetaFactory.get(IASWebDataService.class);
        }
        catch (MetaFactoryException e) {
            LoggerFactory.getLogger(BoxDecorator.class).error(MarkerFactory.getMarker((String)"FATAL"), "IASWebDataService asg service init failure", (Throwable)e);
        }
    }
}

