/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.decorator;

import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.asfederateddata.data.BoxType;
import net.anotheria.anosite.gen.asfederateddata.service.IASFederatedDataService;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class BoxTypeDecorator
implements IAttributeDecorator {
    private static IASFederatedDataService federatedDataService;

    public String decorate(DataObject doc, String attributeName, String rule) {
        String linkValue = ((Box)doc).getType();
        Object name = null;
        try {
            BoxType targetType = federatedDataService.getBoxType(linkValue);
            name = targetType.getName();
        }
        catch (NoSuchDocumentException e) {
            name = "*** DELETED ***";
        }
        catch (RuntimeException e) {
            name = "*** ERR: " + e.getMessage() + " ***";
        }
        catch (ASGRuntimeException e) {
            name = "*** ASG-ERR: " + e.getMessage() + " ***";
        }
        return (String)name + " [" + linkValue + "]";
    }

    static {
        try {
            federatedDataService = (IASFederatedDataService)MetaFactory.get(IASFederatedDataService.class);
        }
        catch (MetaFactoryException e) {
            LoggerFactory.getLogger(BoxTypeDecorator.class).error(MarkerFactory.getMarker((String)"FATAL"), "IASFederatedDataService asg service init failure", (Throwable)e);
        }
    }
}

