/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.decorator;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import net.anotheria.anosite.gen.asresourcedata.data.FileLink;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.util.IOUtils;
import net.anotheria.util.NumberUtils;
import net.anotheria.webutils.filehandling.actions.FileStorage;

public class FileSizeDecorator
implements IAttributeDecorator {
    public String decorate(DataObject doc, String attributeName, String rule) {
        if (doc instanceof Image) {
            return this.processImage((Image)doc, attributeName, rule);
        }
        if (doc instanceof FileLink) {
            return this.processFile((FileLink)doc, attributeName, rule);
        }
        return "";
    }

    private String processImage(Image img, String attributeName, String rule) {
        String fileName = img.getImage();
        return this.processFile(fileName);
    }

    private String processFile(FileLink f, String attributeName, String rule) {
        String fileName = f.getFile();
        return this.processFile(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processFile(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return "No file";
        }
        String message = null;
        FileInputStream fIn = null;
        try {
            File f = new File(FileStorage.fileStorageDir + File.separatorChar + fileName);
            if (!f.exists()) {
                message = "Missing " + fileName;
            } else {
                fIn = new FileInputStream(f);
                message = NumberUtils.makeSizeString((long)fIn.available()) + " " + fileName;
            }
            IOUtils.closeIgnoringException((Closeable)fIn);
        }
        catch (Exception e) {
            message = "Error: " + e.getMessage();
        }
        finally {
            IOUtils.closeIgnoringException(fIn);
        }
        return message;
    }
}

