/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.decorator;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.webutils.filehandling.actions.FileStorage;

public class ImageSizeDecorator
implements IAttributeDecorator {
    public String decorate(DataObject doc, String attributeName, String rule) {
        if (doc instanceof Image) {
            return this.processImage((Image)doc, attributeName, rule);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String processImage(Image img, String attributeName, String rule) {
        String fileName = img.getImage();
        if (fileName == null) return "No file";
        if (fileName.length() == 0) {
            return "No file";
        }
        String message = null;
        ImageInputStream iis = null;
        try {
            File f = new File(FileStorage.fileStorageDir + File.separatorChar + fileName);
            if (!f.exists()) {
                String string = "Missing " + fileName;
                return string;
            }
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(fileName.substring(fileName.length() - 3, fileName.length()));
            ImageReader reader = readers.next();
            iis = ImageIO.createImageInputStream(f);
            reader.setInput(iis, false);
            int nImageCount = reader.getNumImages(true);
            if (nImageCount < 1) {
                String string = "Error: ImageReader found no images";
                return string;
            }
            int h = reader.getHeight(0);
            int w = reader.getWidth(0);
            message = w + " x " + h + " pixel";
            return message;
        }
        catch (Exception e) {
            message = "Error: " + e.getMessage();
            return message;
        }
        finally {
            if (iis != null) {
                try {
                    iis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

