/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.decorator;

import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.asfederateddata.service.IASFederatedDataService;
import net.anotheria.anosite.gen.aslayoutdata.service.IASLayoutDataService;
import net.anotheria.anosite.gen.assitedata.data.EntryPoint;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.anosite.gen.assitedata.data.PageAlias;
import net.anotheria.anosite.gen.assitedata.data.PageTemplate;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.anosite.gen.assitedata.service.IASSiteDataService;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class LinkTargetNameDecorator
implements IAttributeDecorator {
    private static IASFederatedDataService federatedDataService;
    private static IASSiteDataService siteDataService;
    private static IASWebDataService webDataService;
    private static IASLayoutDataService layoutDataService;

    public String decorate(DataObject doc, String attributeName, String rule) {
        Object name = "Unknown";
        Object linkValue = "?";
        try {
            Object link = doc.getPropertyValue(attributeName);
            Object object = linkValue = link == null ? null : "" + link;
            if (linkValue == null || ((String)linkValue).length() == 0) {
                return "----";
            }
            if (doc instanceof PageTemplate) {
                name = this.getTargetNameForTemplate((PageTemplate)doc, attributeName);
            }
            if (doc instanceof NaviItem) {
                name = this.getTargetNameForNaviItem((NaviItem)doc, attributeName);
            }
            if (doc instanceof Box) {
                name = this.getTargetNameForBox((Box)doc, attributeName);
            }
            if (doc instanceof Pagex) {
                name = this.getTargetNameForPage((Pagex)doc, attributeName);
            }
            if (doc instanceof Site) {
                name = this.getTargetNameForSite((Site)doc, attributeName);
            }
            if (doc instanceof EntryPoint) {
                name = this.getTargetNameForEntryPoint((EntryPoint)doc, attributeName);
            }
            if (doc instanceof PageAlias) {
                name = this.getTargetNameForPageAlias((PageAlias)doc, attributeName);
            }
        }
        catch (NoSuchDocumentException e) {
            name = "*** DELETED ***";
        }
        catch (NoSuchPropertyException e) {
            name = "*** NoProp ***";
        }
        catch (RuntimeException e) {
            name = "*** ERR: " + e.getMessage() + " ***";
        }
        catch (ASGRuntimeException e) {
            name = "*** ASG-ERR: " + e.getMessage() + " ***";
        }
        return (String)name + " [" + (String)linkValue + "]";
    }

    private String getTargetNameForNaviItem(NaviItem item, String attributeName) throws ASGRuntimeException {
        if (attributeName.equals("internalLink")) {
            return webDataService.getPagex(item.getInternalLink()).getName();
        }
        if (attributeName.equals("pageAlias")) {
            return siteDataService.getPageAlias(item.getPageAlias()).getName();
        }
        return "Unknown attribute: " + attributeName;
    }

    private String getTargetNameForTemplate(PageTemplate template, String attributeName) throws ASGRuntimeException {
        if (attributeName.equals("site")) {
            return siteDataService.getSite(template.getSite()).getName();
        }
        if (attributeName.equals("layout")) {
            return layoutDataService.getPageLayout(template.getLayout()).getName();
        }
        return "Unknown attribute: " + attributeName;
    }

    private String getTargetNameForSite(Site site, String attributeName) throws ASGRuntimeException {
        if (attributeName.equals("startpage")) {
            return webDataService.getPagex(site.getStartpage()).getName();
        }
        return "Unknown attribute: " + attributeName;
    }

    private String getTargetNameForEntryPoint(EntryPoint entry, String attributeName) throws ASGRuntimeException {
        if (attributeName.equals("startPage")) {
            return webDataService.getPagex(entry.getStartPage()).getName();
        }
        if (attributeName.equals("startSite")) {
            return siteDataService.getSite(entry.getStartSite()).getName();
        }
        return "Unknown attribute: " + attributeName;
    }

    private String getTargetNameForPageAlias(PageAlias entry, String attributeName) throws ASGRuntimeException {
        if (attributeName.equals("targetPage")) {
            return webDataService.getPagex(entry.getTargetPage()).getName();
        }
        return "Unknown attribute: " + attributeName;
    }

    private String getTargetNameForBox(Box box, String attributeName) throws ASGRuntimeException {
        if (attributeName.equals("handler")) {
            return federatedDataService.getBoxHandlerDef(box.getHandler()).getName();
        }
        if (attributeName.equals("type")) {
            return federatedDataService.getBoxType(box.getType()).getName();
        }
        return "UnknownAttr: " + attributeName;
    }

    private String getTargetNameForPage(Pagex page, String attributeName) throws ASGRuntimeException {
        if (attributeName.equals("template")) {
            return siteDataService.getPageTemplate(page.getTemplate()).getName();
        }
        return "UnknownAttr: " + attributeName;
    }

    static {
        try {
            federatedDataService = (IASFederatedDataService)MetaFactory.get(IASFederatedDataService.class);
            siteDataService = (IASSiteDataService)MetaFactory.get(IASSiteDataService.class);
            webDataService = (IASWebDataService)MetaFactory.get(IASWebDataService.class);
            layoutDataService = (IASLayoutDataService)MetaFactory.get(IASLayoutDataService.class);
        }
        catch (MetaFactoryException e) {
            LoggerFactory.getLogger(LinkTargetNameDecorator.class).error(MarkerFactory.getMarker((String)"FATAL"), "ASG service init failure", (Throwable)e);
        }
    }
}

