/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.decorator;

import java.util.ArrayList;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.util.StringUtils;

public abstract class LinksListDecorator
implements IAttributeDecorator {
    public String decorate(DataObject doc, String attributeName, String rule) {
        try {
            ArrayList links = null;
            try {
                links = ((Document)doc).getListProperty(attributeName).getListData();
            }
            catch (NoSuchPropertyException e) {
                links = new ArrayList(0);
            }
            String value = links.size() + " [";
            Object linksValue = "";
            Object title = "";
            for (Object l : links) {
                Object name;
                try {
                    name = this.getLinkTargetName("" + l);
                }
                catch (NoSuchDocumentException e) {
                    name = "*DELETED*";
                }
                catch (ASGRuntimeException e) {
                    name = "*ASG-ERR: " + e.getMessage() + "*";
                }
                if (((String)title).length() > 0) {
                    title = (String)title + ", ";
                }
                if (((String)linksValue).length() > 0) {
                    linksValue = (String)linksValue + ", ";
                }
                linksValue = (String)linksValue + (String)name + "(" + l + ")";
                title = (String)title + (String)name;
            }
            value = value + (String)linksValue + "]";
            String href = doc.getDefinedParentName().toLowerCase() + StringUtils.capitalize((String)doc.getDefinedName()) + StringUtils.capitalize((String)attributeName) + "Show?pId=" + doc.getId() + "&ownerId=" + doc.getId() + "&ts=" + System.currentTimeMillis();
            if (((String)title).length() > 0) {
                title = " title=\"" + (String)title + "\"";
            }
            String hrefTarget = href.length() > 1 ? " target=\"_blank\"" : "";
            return "<a href=\"" + href + "\"" + hrefTarget + (String)title + ">" + value + "</a>";
        }
        catch (NoSuchPropertyException e) {
            return "none";
        }
    }

    protected abstract String getLinkTargetName(String var1) throws ASGRuntimeException;
}

