/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.decorator;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.util.StringUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class NaviItemDecorator
implements IAttributeDecorator {
    private static IASWebDataService service;

    public String decorate(DataObject doc, String attributeName, String rule) {
        try {
            ArrayList links = null;
            try {
                links = ((Document)doc).getListProperty(attributeName).getListData();
            }
            catch (NoSuchPropertyException e) {
                links = new ArrayList(0);
            }
            ArrayList<CallSite> ids = new ArrayList<CallSite>(links.size());
            String value = links.size() + " [";
            Object linksValue = "";
            for (Object l : links) {
                if (((String)linksValue).length() > 0) {
                    linksValue = (String)linksValue + ", ";
                }
                linksValue = (String)linksValue + l;
                ids.add((CallSite)((Object)("" + l)));
            }
            value = value + (String)linksValue + "]";
            Object href = "#";
            if (doc instanceof Site) {
                href = doc.getDefinedParentName().toLowerCase() + "Site" + StringUtils.capitalize((String)attributeName) + "Show?pId=" + doc.getId() + "&ownerId=" + doc.getId() + "&ts=" + System.currentTimeMillis();
            }
            if (doc instanceof NaviItem) {
                href = doc.getDefinedParentName().toLowerCase() + "NaviItem" + StringUtils.capitalize((String)attributeName) + "Show?pId=" + doc.getId() + "&ownerId=" + doc.getId() + "&ts=" + System.currentTimeMillis();
            }
            StringBuilder title = new StringBuilder();
            for (String string : ids) {
                Object name;
                try {
                    name = service.getPagex(string).getName();
                }
                catch (NoSuchDocumentException e) {
                    name = "*DELETED*";
                }
                catch (ASGRuntimeException e) {
                    name = "*ERR-" + e.getMessage() + "*";
                }
                if (title.length() > 0) {
                    title.append(", ");
                }
                title.append((String)name);
            }
            Object titleString = "";
            if (title.length() > 0) {
                titleString = " title=\"" + title.toString() + "\"";
            }
            String string = ((String)href).length() > 1 ? " target=\"_blank\"" : "";
            return "<a href=\"" + (String)href + "\"" + string + (String)titleString + ">" + value + "</a>";
        }
        catch (NoSuchPropertyException e) {
            return "none";
        }
    }

    static {
        try {
            service = (IASWebDataService)MetaFactory.get(IASWebDataService.class);
        }
        catch (MetaFactoryException e) {
            LoggerFactory.getLogger(NaviItemDecorator.class).error(MarkerFactory.getMarker((String)"FATAL"), "IASSiteDataService  init failure", (Throwable)e);
        }
    }
}

