/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.guard;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDef;
import net.anotheria.anosite.gen.asfederateddata.service.IASFederatedDataService;
import net.anotheria.anosite.guard.ConditionalGuard;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public final class GuardFactory {
    private static Map<String, ConditionalGuard> guards = new ConcurrentHashMap<String, ConditionalGuard>();
    private static IASFederatedDataService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConditionalGuard getConditionalGuard(String id) {
        ConditionalGuard g = null;
        g = guards.get(id);
        if (g == null) {
            Map<String, ConditionalGuard> map = guards;
            synchronized (map) {
                g = guards.get(id);
                if (g == null) {
                    try {
                        GuardDef def = service.getGuardDef(id);
                        g = (ConditionalGuard)Class.forName(def.getClazz()).newInstance();
                        guards.put(id, g);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Couldn't retrieve guard definition: " + e.getMessage() + ", gid: " + id);
                    }
                }
            }
        }
        return g;
    }

    private GuardFactory() {
    }

    static {
        try {
            service = (IASFederatedDataService)MetaFactory.get(IASFederatedDataService.class);
        }
        catch (MetaFactoryException e) {
            LoggerFactory.getLogger(GuardFactory.class).error(MarkerFactory.getMarker((String)"FATAL"), "IASFederatedDataService init failure", (Throwable)e);
        }
    }
}

