/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import net.anotheria.anoplass.api.APICallContext;
import net.anotheria.anoplass.api.session.APISessionImpl;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.content.bean.BoxBean;
import net.anotheria.anosite.gen.asresourcedata.data.TextResource;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.handler.BoxHandler;
import net.anotheria.anosite.handler.BoxHandlerResponse;
import net.anotheria.anosite.handler.ResponseContinue;
import net.anotheria.anosite.handler.exception.BoxProcessException;
import net.anotheria.anosite.handler.exception.BoxSubmitException;
import net.anotheria.anosite.localization.LocalizationMap;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public abstract class AbstractBoxHandler
implements BoxHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static IASResourceDataService resourceService;

    protected AbstractBoxHandler() {
    }

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public BoxHandlerResponse process(HttpServletRequest req, HttpServletResponse res, Box box, BoxBean bean) throws BoxProcessException {
        return ResponseContinue.INSTANCE;
    }

    @Override
    public BoxHandlerResponse submit(HttpServletRequest req, HttpServletResponse res, Box box) throws BoxSubmitException {
        return ResponseContinue.INSTANCE;
    }

    protected static IASResourceDataService getResourceDataService() {
        return resourceService;
    }

    protected void sendAttributeToPage(String name, Object attribute) {
        ((APISessionImpl)APICallContext.getCallContext().getCurrentSession()).addAttributeToActionScope(name, attribute);
    }

    protected static String getTextResource(String name) {
        try {
            String txt;
            LocalizationMap localization = (LocalizationMap)APICallContext.getCallContext().getAttribute(LocalizationMap.CALL_CONTEXT_SCOPE_NAME);
            String string = txt = localization != null ? localization.getMessage(name) : null;
            if (!StringUtils.isEmpty((String)txt)) {
                return txt;
            }
            List resources = AbstractBoxHandler.getResourceDataService().getTextResourcesByProperty("name", (Object)name);
            if (resources == null || resources.size() == 0) {
                return "Missing key: " + name;
            }
            return ((TextResource)resources.get(0)).getValue();
        }
        catch (ASGRuntimeException e) {
            String message = "getTextResourceByName(" + name + ") fail.";
            LoggerFactory.getLogger(AbstractBoxHandler.class).error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    static {
        try {
            resourceService = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException e) {
            LoggerFactory.getLogger(AbstractBoxHandler.class).error(MarkerFactory.getMarker((String)"FATAL"), "IASResourceDataService init failure", (Throwable)e);
        }
    }
}

