/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.handler;

import java.util.HashMap;
import java.util.Map;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.asfederateddata.data.BoxHandlerDef;
import net.anotheria.anosite.gen.asfederateddata.service.IASFederatedDataService;
import net.anotheria.anosite.handler.BoxHandler;
import net.anotheria.anosite.handler.BoxHandlerProducer;
import net.anotheria.anosite.handler.BoxHandlerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class BoxHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoxHandlerFactory.class);
    private static IASFederatedDataService service;
    private static Map<String, BoxHandlerProducer> producers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BoxHandler createHandler(String id) {
        try {
            BoxHandlerDef def = service.getBoxHandlerDef(id);
            String producerId = def.getClazz() + "-" + def.getId();
            BoxHandlerProducer producer = producers.get(producerId);
            if (producer == null) {
                Map<String, BoxHandlerProducer> map = producers;
                synchronized (map) {
                    producer = producers.get(producerId);
                    if (producer == null) {
                        producer = new BoxHandlerProducer(producerId);
                        producers.put(producerId, producer);
                    }
                }
            }
            BoxHandlerWrapper wrapper = new BoxHandlerWrapper(producer, (BoxHandler)Class.forName(def.getClazz()).newInstance());
            return wrapper;
        }
        catch (Exception e) {
            LOGGER.error("createHandler(" + id + ")", (Throwable)e);
            throw new RuntimeException("Handler instantiation failed - " + e.getMessage());
        }
    }

    static {
        try {
            service = (IASFederatedDataService)MetaFactory.get(IASFederatedDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "IASFederatedDataService init failure", (Throwable)e);
        }
        producers = new HashMap<String, BoxHandlerProducer>();
    }
}

