/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.anosite.content.bean.BoxBean;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.handler.BoxHandler;
import net.anotheria.anosite.handler.BoxHandlerResponse;
import net.anotheria.anosite.handler.ResponseAbort;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.context.CurrentMeasurement;
import net.anotheria.moskito.core.context.MoSKitoContext;
import net.anotheria.moskito.core.predefined.ActionStats;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.stats.Interval;

public class BoxHandlerProducer
implements IStatsProducer {
    private String producerId;
    private ActionStats processStats;
    private ActionStats submitStats;
    private final List<IStats> myStats;

    public BoxHandlerProducer(String aProducerId) {
        this.producerId = aProducerId;
        this.processStats = new ActionStats("process", this.getMonitoringIntervals());
        this.submitStats = new ActionStats("submit", this.getMonitoringIntervals());
        this.myStats = new ArrayList<IStats>();
        this.myStats.add((IStats)this.processStats);
        this.myStats.add((IStats)this.submitStats);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)this);
    }

    protected Interval[] getMonitoringIntervals() {
        return Constants.getDefaultIntervals();
    }

    public String getCategory() {
        return "box-handler";
    }

    public String getProducerId() {
        return this.producerId;
    }

    public List<IStats> getStats() {
        return this.myStats;
    }

    public String getSubsystem() {
        return "ano-site";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BoxHandlerResponse process(HttpServletRequest req, HttpServletResponse res, Box box, BoxBean bean, BoxHandler target) {
        CurrentlyTracedCall runningUseCase;
        MoSKitoContext moSKitoContext = MoSKitoContext.get();
        CurrentMeasurement cm = moSKitoContext.notifyProducerEntry((IStatsProducer)this);
        if (cm.isFirst()) {
            cm.setCallDescription("process Box: " + box.getName() + " [" + box.getId() + "]");
        }
        this.processStats.addRequest();
        long startTime = System.nanoTime();
        TracedCall aRunningUseCase = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentElement = null;
        CurrentlyTracedCall currentlyTracedCall = runningUseCase = aRunningUseCase.callTraced() ? (CurrentlyTracedCall)aRunningUseCase : null;
        if (runningUseCase != null) {
            currentElement = runningUseCase.startStep(this.getProducerId() + '.' + "process", (IStatsProducer)this, "process");
        }
        try {
            BoxHandlerResponse boxHandlerResponse = target.process(req, res, box, bean);
            return boxHandlerResponse;
        }
        catch (Exception e) {
            this.processStats.notifyError();
            ResponseAbort responseAbort = new ResponseAbort(e);
            return responseAbort;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            moSKitoContext.notifyProducerExit((IStatsProducer)this);
            cm.notifyProducerFinished();
            this.processStats.addExecutionTime(duration);
            this.processStats.notifyRequestFinished();
            if (currentElement != null) {
                currentElement.setDuration(duration);
            }
            if (runningUseCase != null) {
                runningUseCase.endStep();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BoxHandlerResponse submit(HttpServletRequest req, HttpServletResponse res, Box box, BoxHandler target) {
        CurrentlyTracedCall runningUseCase;
        MoSKitoContext moSKitoContext = MoSKitoContext.get();
        CurrentMeasurement cm = moSKitoContext.notifyProducerEntry((IStatsProducer)this);
        if (cm.isFirst()) {
            cm.setCallDescription("submit Box: " + box.getName() + " [" + box.getId() + "]");
        }
        this.submitStats.addRequest();
        long startTime = System.nanoTime();
        TracedCall aRunningUseCase = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentElement = null;
        CurrentlyTracedCall currentlyTracedCall = runningUseCase = aRunningUseCase.callTraced() ? (CurrentlyTracedCall)aRunningUseCase : null;
        if (runningUseCase != null) {
            currentElement = runningUseCase.startStep(this.getProducerId() + '.' + "submit", (IStatsProducer)this, "submit");
        }
        try {
            BoxHandlerResponse boxHandlerResponse = target.submit(req, res, box);
            return boxHandlerResponse;
        }
        catch (Exception e) {
            this.processStats.notifyError();
            ResponseAbort responseAbort = new ResponseAbort(e);
            return responseAbort;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            moSKitoContext.notifyProducerExit((IStatsProducer)this);
            this.submitStats.addExecutionTime(duration);
            this.submitStats.notifyRequestFinished();
            if (currentElement != null) {
                currentElement.setDuration(duration);
            }
            if (runningUseCase != null) {
                runningUseCase.endStep();
            }
        }
    }
}

