/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.handler.def;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.anosite.content.bean.BoxBean;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.handler.AbstractBoxHandler;
import net.anotheria.anosite.handler.BoxHandlerResponse;
import net.anotheria.anosite.handler.ResponseRedirectImmediately;
import net.anotheria.anosite.handler.exception.BoxSubmitException;
import net.anotheria.util.StringUtils;

public class RedirectImmediatelyHandler
extends AbstractBoxHandler {
    @Override
    public BoxHandlerResponse process(HttpServletRequest req, HttpServletResponse res, Box box, BoxBean bean) {
        return this.getRedirect(req, res, box);
    }

    @Override
    public BoxHandlerResponse submit(HttpServletRequest req, HttpServletResponse res, Box box) throws BoxSubmitException {
        return this.getRedirect(req, res, box);
    }

    private BoxHandlerResponse getRedirect(HttpServletRequest req, HttpServletResponse res, Box box) {
        String urlQuery = req.getQueryString();
        String redirectTarget = box.getParameter1();
        String separator = redirectTarget.contains("?") ? "&" : "?";
        separator = !StringUtils.isEmpty((String)urlQuery) && urlQuery.startsWith(separator) ? "" : separator;
        String redirectURL = StringUtils.isEmpty((String)urlQuery) ? redirectTarget : redirectTarget + separator + urlQuery;
        return new ResponseRedirectImmediately(redirectURL);
    }
}

