/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.handler.validation;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import net.anotheria.anosite.content.bean.BoxBean;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.handler.AbstractBoxHandler;
import net.anotheria.anosite.handler.BoxHandlerResponse;
import net.anotheria.anosite.handler.ResponseContinue;
import net.anotheria.anosite.handler.exception.BoxHandleException;
import net.anotheria.anosite.handler.exception.BoxProcessException;
import net.anotheria.anosite.handler.exception.BoxSubmitException;
import net.anotheria.anosite.handler.validation.AbstractFormBean;
import net.anotheria.anosite.handler.validation.ValidationResponse;
import net.anotheria.anosite.handler.validation.ValidationSettings;
import net.anotheria.util.StringUtils;

public abstract class AbstractValidationBoxHandler<T extends AbstractFormBean>
extends AbstractBoxHandler {
    public static final String JSON_RESPONSE_CODEPAGE = "UTF-8";
    public static final String JSON_RESPONSE_CONTENT_TYPE = "text/x-json";
    public static final String REQ_PARAM_VALIDATION_ONLY = "validationOnly";
    private static final String ATTR_FORM_BEAN = "formBean";
    private static final String ATTR_VALIDATION_RESPONSE = "validationResponse";
    private static final String ATTR_VALIDATION_SETTINGS = "validationSettings";
    public static final String ATTR_VALIDATION_RESPONSE_STRING = "vResponse";
    public static final String ATTR_VALIDATION_SETTINGS_STRING = "vSettings";

    @Override
    public final BoxHandlerResponse process(HttpServletRequest req, HttpServletResponse res, Box box, BoxBean bean) throws BoxProcessException {
        BoxHandlerResponse response = this.executeProcess(req, res, box, bean);
        ValidationSettings vSettings = this.getFormValidationSettings(req);
        this.prepareFormValidationSettings(vSettings);
        req.setAttribute(ATTR_VALIDATION_SETTINGS_STRING, (Object)vSettings.toString());
        ValidationResponse vResponse = (ValidationResponse)ValidationResponse.class.cast(req.getAttribute(this.getFormId() + ATTR_VALIDATION_RESPONSE));
        if (vResponse != null && vResponse.hasErrors()) {
            T formBean = this.getFormBean(req);
            this.publishFormBean(formBean, req);
            req.setAttribute(ATTR_VALIDATION_RESPONSE_STRING, (Object)vResponse.toString());
        }
        return response;
    }

    @Override
    public final BoxHandlerResponse submit(HttpServletRequest req, HttpServletResponse res, Box box) throws BoxSubmitException {
        boolean isValidationOnly;
        ValidationResponse vResponse;
        if (StringUtils.isEmpty((String)this.getFormId()) || StringUtils.isEmpty((String)req.getParameter(this.getFormId()))) {
            return ResponseContinue.INSTANCE;
        }
        try {
            vResponse = this.validate(req, res, box);
            req.setAttribute(this.getFormId() + ATTR_VALIDATION_RESPONSE, (Object)vResponse);
        }
        catch (BoxHandleException e) {
            throw new BoxSubmitException(e);
        }
        boolean bl = isValidationOnly = req.getParameter(REQ_PARAM_VALIDATION_ONLY) != null;
        if (isValidationOnly) {
            return this.writeJSONResponse(res, vResponse.toString());
        }
        if (!vResponse.hasErrors()) {
            return this.executeSubmit(req, res, box);
        }
        return ResponseContinue.INSTANCE;
    }

    protected BoxHandlerResponse executeProcess(HttpServletRequest req, HttpServletResponse res, Box box, BoxBean bean) throws BoxProcessException {
        return super.process(req, res, box, bean);
    }

    protected BoxHandlerResponse executeSubmit(HttpServletRequest req, HttpServletResponse res, Box box) throws BoxSubmitException {
        return super.submit(req, res, box);
    }

    protected void prepareFormValidationSettings(ValidationSettings vSettings) {
    }

    protected final ValidationSettings getFormValidationSettings(HttpServletRequest req) {
        Object vSettingsObj = req.getAttribute(ATTR_VALIDATION_SETTINGS);
        if (vSettingsObj != null) {
            return (ValidationSettings)ValidationSettings.class.cast(vSettingsObj);
        }
        ValidationSettings vSettings = ValidationSettings.create();
        req.setAttribute(ATTR_VALIDATION_SETTINGS, (Object)vSettings);
        return vSettings;
    }

    protected final T getFormBean(HttpServletRequest req) {
        Object beanObj = req.getAttribute(this.getFormId() + ATTR_FORM_BEAN);
        if (beanObj != null) {
            return (T)((AbstractFormBean)this.getFormBeanClass().cast(beanObj));
        }
        T bean = this.prepareFormBean(this.createFormBean(), req);
        req.setAttribute(this.getFormId() + ATTR_FORM_BEAN, bean);
        return bean;
    }

    protected final void publishFormBean(T formBean, HttpServletRequest req) {
        for (String fieldName : ((AbstractFormBean)formBean).getFieldsNames()) {
            req.setAttribute(fieldName, ((AbstractFormBean)formBean).getFieldValue(fieldName));
        }
    }

    private final T prepareFormBean(T bean, HttpServletRequest req) {
        ((AbstractFormBean)bean).prepare(req);
        return bean;
    }

    protected final T createFormBean() {
        try {
            return (T)((AbstractFormBean)this.getFormBeanClass().newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Can't instantiate form bean.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Can't instantiate form bean.", e);
        }
    }

    protected abstract Class<T> getFormBeanClass();

    protected abstract String getFormId();

    protected ValidationResponse validate(HttpServletRequest req, HttpServletResponse res, Box box) throws BoxHandleException {
        return ValidationResponse.EMPTY_RESPONSE;
    }

    protected final BoxHandlerResponse writeJSONResponse(HttpServletResponse res, String json) throws BoxSubmitException {
        res.setCharacterEncoding(JSON_RESPONSE_CODEPAGE);
        res.setContentType(JSON_RESPONSE_CONTENT_TYPE);
        try {
            PrintWriter writer = res.getWriter();
            writer.write(json);
            writer.flush();
            return ResponseContinue.INSTANCE;
        }
        catch (IOException e) {
            throw new BoxSubmitException(e);
        }
    }
}

