/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.handler.validation;

import net.anotheria.anosite.handler.validation.ValidatorSettings;
import org.json.JSONException;
import org.json.JSONObject;

public class LengthValidatorSettings
implements ValidatorSettings {
    private static final long serialVersionUID = -6841822238596021396L;
    public static final String JSON_SETTINGS_NAME = "validate-length";
    public static final String JSON_SETTINGS_MIN_NAME = "min";
    public static final String JSON_SETTINGS_MAX_NAME = "max";
    public static final String JSON_SETTINGS_LESS_THEN_MIN_ERROR_KEY_NAME = "notValidMsg-tooShort";
    public static final String JSON_SETTINGS_MORE_THEN_MAX_ERROR_KEY_NAME = "notValidMsg-tooLong";
    private int min = 0;
    private int max = Integer.MAX_VALUE;
    private String lessThenMinErrorKey = "";
    private String moreThenMaxErrorKey = "";

    private LengthValidatorSettings() {
    }

    public static final LengthValidatorSettings create() {
        return new LengthValidatorSettings();
    }

    public LengthValidatorSettings setMinLength(int minLength) {
        this.min = minLength;
        return this;
    }

    public LengthValidatorSettings setMaxLength(int maxLength) {
        this.max = maxLength;
        return this;
    }

    public LengthValidatorSettings setLessThenMinErrorKey(String errorKey) {
        this.lessThenMinErrorKey = errorKey;
        return this;
    }

    public LengthValidatorSettings setMoreThenMaxErrorKey(String errorKey) {
        this.moreThenMaxErrorKey = errorKey;
        return this;
    }

    @Override
    public String getName() {
        return JSON_SETTINGS_NAME;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    @Override
    public JSONObject toJSON() {
        try {
            JSONObject result = new JSONObject();
            result.put(JSON_SETTINGS_MIN_NAME, this.min);
            result.put(JSON_SETTINGS_MAX_NAME, this.max);
            result.put(JSON_SETTINGS_LESS_THEN_MIN_ERROR_KEY_NAME, (Object)this.lessThenMinErrorKey);
            result.put(JSON_SETTINGS_MORE_THEN_MAX_ERROR_KEY_NAME, (Object)this.moreThenMaxErrorKey);
            return result;
        }
        catch (JSONException e) {
            throw new RuntimeException("Preparing JSON fail.", e);
        }
    }
}

