/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.handler.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.util.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ValidationResponse
implements Serializable {
    private static final long serialVersionUID = -4130382436892907495L;
    public static final ValidationResponse EMPTY_RESPONSE = new ValidationResponse("empty-response");
    private final Map<String, FieldData> fieldsData = new HashMap<String, FieldData>();
    private final String formId;

    public static ValidationResponse create(String aFormId) {
        return new ValidationResponse(aFormId);
    }

    private ValidationResponse(String aFormId) {
        if (StringUtils.isEmpty((String)aFormId)) {
            throw new IllegalArgumentException("empty form id");
        }
        this.formId = aFormId;
    }

    public void addError(String fieldName, String errorKey) {
        FieldData fData = this.fieldsData.get(fieldName);
        if (fData == null) {
            fData = new FieldData();
            this.fieldsData.put(fieldName, fData);
        }
        fData.addErrorKey(errorKey);
    }

    public boolean hasErrors() {
        return !this.fieldsData.isEmpty();
    }

    public final String toString() {
        try {
            return this.asJSON();
        }
        catch (JSONException e) {
            throw new RuntimeException("Preparing JSON fail.", e);
        }
    }

    private String asJSON() throws JSONException {
        JSONObject result = new JSONObject();
        result.put("status", (Object)(this.hasErrors() ? "ERROR" : "OK"));
        result.put("formId", (Object)this.formId);
        if (this.hasErrors()) {
            JSONObject errorsScope = new JSONObject();
            for (String fieldName : this.fieldsData.keySet()) {
                errorsScope.put(fieldName, (Object)new JSONArray(this.fieldsData.get(fieldName).getErrorsKeys()));
            }
            result.put("errors", (Object)errorsScope);
        }
        return result.toString();
    }

    public static void main(String ... args) {
        ValidationResponse vr = ValidationResponse.create("testForm");
        System.out.println(vr.toString());
        vr.addError("testField1", "error-key");
        vr.addError("testField2", "error-key-1");
        vr.addError("testField2", "error-key-2");
        System.out.println(vr.toString());
    }

    private final class FieldData {
        private final List<String> errorsKeys = new ArrayList<String>();

        public List<String> getErrorsKeys() {
            return this.errorsKeys;
        }

        public void addErrorKey(String errorKey) {
            this.errorsKeys.add(errorKey);
        }
    }
}

