/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.handler.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.anotheria.anosite.handler.validation.ComplexityValidatorSettings;
import net.anotheria.anosite.handler.validation.EmptyValidatorSettings;
import net.anotheria.anosite.handler.validation.LengthValidatorSettings;
import net.anotheria.anosite.handler.validation.ValidatorSettings;
import org.json.JSONException;
import org.json.JSONObject;

public class ValidationSettings
implements Serializable {
    private static final long serialVersionUID = 8254603089207267928L;
    private final Map<String, String> messages = new HashMap<String, String>();
    private final Map<String, FormSettings> settings = new HashMap<String, FormSettings>();

    public static ValidationSettings create() {
        return new ValidationSettings();
    }

    private ValidationSettings() {
    }

    public void addMessage(String key, String message) {
        this.messages.put(key, message);
    }

    public void addValidatorSettings(String formId, String fieldName, ValidatorSettings validatorSettings) {
        FormSettings formSettings = this.settings.get(formId);
        if (formSettings == null) {
            formSettings = new FormSettings();
            this.settings.put(formId, formSettings);
        }
        formSettings.getFieldSettings(fieldName).addValidatorSettings(validatorSettings);
    }

    public void addValidKey(String formId, String fieldName, String validKey) {
        FormSettings formSettings = this.settings.get(formId);
        if (formSettings == null) {
            formSettings = new FormSettings();
            this.settings.put(formId, formSettings);
        }
        formSettings.getFieldSettings(fieldName).setValidKey(validKey);
    }

    public final String toString() {
        try {
            return this.asJSON();
        }
        catch (JSONException e) {
            throw new RuntimeException("Preparing JSON fail.", e);
        }
    }

    private String asJSON() throws JSONException {
        JSONObject result = new JSONObject();
        JSONObject messagesScope = new JSONObject();
        Iterator<String> iterator = this.messages.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String message = this.messages.get(key = iterator.next());
            messagesScope.put(key, (Object)(message != null ? message : ""));
        }
        result.put("_messages", (Object)messagesScope);
        for (String formName : this.settings.keySet()) {
            FormSettings formSettings = this.settings.get(formName);
            if (formSettings == null) continue;
            JSONObject formJSON = new JSONObject();
            for (String fieldName : formSettings.getFieldsNames()) {
                FieldSettings fieldSettings = formSettings.getFieldSettings(fieldName);
                JSONObject fieldJSON = new JSONObject();
                fieldJSON.put("validation", fieldSettings.isValidationEnabled());
                fieldJSON.put("validMsg", (Object)fieldSettings.getValidKey());
                for (ValidatorSettings vs : fieldSettings.getValidatorsSettings()) {
                    fieldJSON.put(vs.getName(), (Object)vs.toJSON());
                }
                formJSON.put(fieldName, (Object)fieldJSON);
            }
            result.put(formName, (Object)formJSON);
        }
        return result.toString();
    }

    public static void main(String ... args) {
        ValidationSettings vs = ValidationSettings.create();
        System.out.println(vs.toString());
        vs.addMessage("msg-input1-valid", "");
        vs.addMessage("msg-input1-empty", "Empty field");
        System.out.println(vs.toString());
        ValidatorSettings s = LengthValidatorSettings.create().setMaxLength(24).setMoreThenMaxErrorKey("not-valid-key-too-long");
        vs.addValidatorSettings("sampleForm1", "sampleField1", s);
        vs.addValidKey("sampleForm1", "sampleField1", "valid-key");
        s = EmptyValidatorSettings.create().setErrorKey("not-valid-key-empty-field-value");
        vs.addValidatorSettings("sampleForm2", "sampleField2", s);
        vs.addValidKey("sampleForm2", "sampleField2", "valid-key");
        s = ComplexityValidatorSettings.create().setRequireNumbers(true).setRequireLowerCase(true).setErrorKey("not-valid-key-no-complexity");
        vs.addValidatorSettings("sampleForm2", "samplePasswordField2", s);
        vs.addValidKey("sampleForm2", "samplePasswordField2", "valid-password-key");
        System.out.println(vs.toString());
    }

    private class FieldSettings
    implements Serializable {
        private static final long serialVersionUID = 1990525389220790133L;
        private final List<ValidatorSettings> vSettings = new ArrayList<ValidatorSettings>();
        private String validKey = "";

        private FieldSettings() {
        }

        public void addValidatorSettings(ValidatorSettings vs) {
            this.vSettings.add(vs);
        }

        public List<ValidatorSettings> getValidatorsSettings() {
            return this.vSettings;
        }

        public void setValidKey(String aValidKey) {
            this.validKey = aValidKey;
        }

        public String getValidKey() {
            return this.validKey;
        }

        public boolean isValidationEnabled() {
            return !this.vSettings.isEmpty();
        }
    }

    private class FormSettings
    implements Serializable {
        private static final long serialVersionUID = 4537893175895803885L;
        private Map<String, FieldSettings> fSettings = new HashMap<String, FieldSettings>();

        private FormSettings() {
        }

        public FieldSettings getFieldSettings(String fieldName) {
            FieldSettings fs = this.fSettings.get(fieldName);
            if (fs == null) {
                fs = new FieldSettings();
                this.fSettings.put(fieldName, fs);
            }
            return fs;
        }

        public Set<String> getFieldsNames() {
            return this.fSettings.keySet();
        }
    }
}

