/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.localization;

import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleDocument;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.maf.json.JSONResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/ImportLocalizationBundle"})
@MultipartConfig
public class LocalizationBundleImportServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalizationBundleImportServlet.class);
    private IASResourceDataService resourceDataService;

    public LocalizationBundleImportServlet() {
        try {
            this.resourceDataService = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException metaFactoryException) {
            // empty catch block
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JSONResponse jsonResponse = new JSONResponse();
        try {
            Part file = request.getPart("file");
            String locale = request.getParameter("locale");
            String result = IOUtils.toString((InputStream)file.getInputStream(), (Charset)StandardCharsets.UTF_8);
            String[] values = result.split("\n");
            HashMap<String, Map> bundlesMap = new HashMap<String, Map>();
            String prevKey = "";
            boolean duplicateKey = false;
            for (String row : values) {
                try {
                    Map keyValueMap;
                    String slesh;
                    String bundleId = row.substring(0, row.indexOf("."));
                    String keyValuePair = row.substring(row.indexOf(".") + 1);
                    String key = prevKey;
                    String value = keyValuePair;
                    if (keyValuePair.contains("=") && keyValuePair.indexOf("=") > 0 && !(slesh = keyValuePair.substring(keyValuePair.indexOf("=") - 1, keyValuePair.indexOf("="))).equals("\\")) {
                        key = keyValuePair.substring(0, keyValuePair.indexOf("="));
                        duplicateKey = prevKey.equals(key);
                        prevKey = key;
                        String string = value = keyValuePair.length() > key.length() + 1 ? keyValuePair.substring(keyValuePair.indexOf("=") + 1) : "";
                    }
                    if (!bundlesMap.containsKey(bundleId)) {
                        bundlesMap.put(bundleId, new HashMap());
                    }
                    if ((keyValueMap = (Map)bundlesMap.get(bundleId)).containsKey(key) && !duplicateKey) {
                        keyValueMap.put(key, (String)keyValueMap.get(key) + "\n" + value);
                    } else {
                        keyValueMap.put(key, value);
                    }
                    bundlesMap.put(bundleId, keyValueMap);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    this.addErrorToJsonResponse(jsonResponse, RESPONSE.SERVER_ERROR);
                    this.writeResponse(response, jsonResponse.toJSON().toString());
                    return;
                }
            }
            StringBuilder oldLocalizationNotUpdated = new StringBuilder();
            ArrayList<LocalizationBundleDocument> bundlesToUpdate = new ArrayList<LocalizationBundleDocument>();
            for (Map.Entry entry : bundlesMap.entrySet()) {
                LocalizationBundle localizationBundle;
                Map newKeyValuePairs = (Map)entry.getValue();
                try {
                    localizationBundle = this.resourceDataService.getLocalizationBundle((String)entry.getKey());
                }
                catch (ASResourceDataServiceException e) {
                    LOGGER.error(e.getMessage());
                    this.addErrorToJsonResponse(jsonResponse, RESPONSE.SERVER_ERROR);
                    continue;
                }
                LocalizationBundleDocument bundleDocument = (LocalizationBundleDocument)localizationBundle;
                StringProperty stringProperty = bundleDocument.getStringProperty("messages_" + locale);
                if (stringProperty == null || stringProperty.getString() == null) {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry keyValuePair : newKeyValuePairs.entrySet()) {
                        sb.append((String)keyValuePair.getKey()).append("=").append((String)keyValuePair.getValue()).append("\n");
                    }
                    stringProperty = new StringProperty("messages_" + locale, sb.toString());
                    bundleDocument.putStringProperty(stringProperty);
                    bundlesToUpdate.add(bundleDocument);
                    continue;
                }
                StringBuilder keyValuePairsToUpdate = new StringBuilder();
                boolean alreadyUpdated = false;
                for (String row : stringProperty.getString().split("\n")) {
                    String oldValue;
                    if ((row = row.trim()).isEmpty()) continue;
                    if (!row.contains("=") || row.indexOf("=") > 0 && "\\".equals(row.substring(row.indexOf("=") - 1, row.indexOf("=")))) {
                        if (alreadyUpdated) continue;
                        keyValuePairsToUpdate.append(row).append("\n");
                        continue;
                    }
                    alreadyUpdated = false;
                    String key = row.substring(0, row.indexOf("="));
                    String string = oldValue = row.length() > key.length() + 1 ? row.substring(row.indexOf("=") + 1) : "";
                    if (newKeyValuePairs.containsKey(key)) {
                        String newValue = (String)newKeyValuePairs.remove(key);
                        keyValuePairsToUpdate.append(key).append("=").append(newValue).append("\n");
                        alreadyUpdated = true;
                        continue;
                    }
                    keyValuePairsToUpdate.append(key).append("=").append(oldValue).append("\n");
                    oldLocalizationNotUpdated.append((String)entry.getKey()).append(".").append(key).append("=").append(oldValue).append("\n");
                }
                if (!newKeyValuePairs.isEmpty()) {
                    for (Map.Entry entry2 : newKeyValuePairs.entrySet()) {
                        keyValuePairsToUpdate.append((String)entry2.getKey()).append("=").append((String)entry2.getValue()).append("\n");
                    }
                }
                stringProperty = new StringProperty("messages_" + locale, keyValuePairsToUpdate.toString());
                bundleDocument.putStringProperty(stringProperty);
                bundlesToUpdate.add(bundleDocument);
            }
            try {
                this.resourceDataService.updateLocalizationBundles(bundlesToUpdate);
            }
            catch (ASResourceDataServiceException e) {
                LOGGER.error(e.getMessage());
                this.addErrorToJsonResponse(jsonResponse, RESPONSE.SERVER_ERROR);
            }
            LOGGER.info("-------------------------------------------------------");
            LOGGER.info("--------  not imported/replaced localizations  --------");
            LOGGER.info(oldLocalizationNotUpdated.toString());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            this.addErrorToJsonResponse(jsonResponse, RESPONSE.SERVER_ERROR);
        }
        this.writeResponse(response, jsonResponse.toJSON().toString());
    }

    private void writeResponse(HttpServletResponse response, String jsonString) throws IOException {
        PrintWriter out = response.getWriter();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        out.print(jsonString);
        out.flush();
    }

    private void addErrorToJsonResponse(JSONResponse jsonResponse, RESPONSE response) {
        jsonResponse.addError(response.name(), response.errorMessage);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    private static enum RESPONSE {
        SERVER_ERROR("Error on file uploading."),
        NOT_MULTIPART_DATA,
        VALIDATION_FAIL("Data is not valid.");

        private String errorMessage;

        private RESPONSE(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        private RESPONSE() {
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

