/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.localization;

import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleDocument;
import net.anotheria.anosite.localization.AbstractLocalizationParentServlet;
import net.anotheria.maf.json.JSONResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@WebServlet(value={"/PreviewParentLocalizationBundle"})
public class LocalizationBundlePreviewParentServlet
extends AbstractLocalizationParentServlet {
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JSONResponse jsonResponse = new JSONResponse();
        try {
            String parentName = request.getParameter("parentName");
            if (StringUtils.isEmpty((CharSequence)parentName)) {
                jsonResponse.addError("NAME", "Parent name is empty");
                this.writeResponse(response, jsonResponse.toJSON().toString());
                return;
            }
            String child1 = request.getParameter("child1");
            String child2 = request.getParameter("child2");
            LocalizationBundleDocument localizationBundle1 = (LocalizationBundleDocument)this.resourceDataService.getLocalizationBundle(child1);
            LocalizationBundleDocument localizationBundle2 = (LocalizationBundleDocument)this.resourceDataService.getLocalizationBundle(child2);
            LocalizationBundleDocument parent = new LocalizationBundleDocument();
            parent.setName(parentName);
            Enumeration keys = localizationBundle1.getKeys();
            ArrayList<String> messagesKeys = new ArrayList<String>();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith("messages")) continue;
                messagesKeys.add(key);
            }
            JSONObject data = new JSONObject();
            JSONArray messagesArray = new JSONArray();
            for (String messageKey : messagesKeys) {
                List<String> values1 = this.getLocalizationValuesByLocale(localizationBundle1, messageKey);
                List<String> values2 = this.getLocalizationValuesByLocale(localizationBundle2, messageKey);
                Map<String, String> keyValuesMap1 = this.getKeyValuePairsMap(values1);
                Map<String, String> keyValuesMap2 = this.getKeyValuePairsMap(values2);
                HashMap<String, String> parentMap = new HashMap<String, String>();
                if (!values1.isEmpty() && !values2.isEmpty()) {
                    for (Map.Entry entry : keyValuesMap1.entrySet()) {
                        if (!keyValuesMap2.containsKey(entry.getKey()) || !((String)entry.getValue()).equals(keyValuesMap2.get(entry.getKey()))) continue;
                        parentMap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                for (String string : parentMap.keySet()) {
                    keyValuesMap1.remove(string);
                    keyValuesMap2.remove(string);
                }
                JSONObject pair = new JSONObject();
                pair.put("messageKey", (Object)messageKey);
                pair.put("parentMessageValue", (Object)this.geKeyValuePairsAsString(parentMap));
                pair.put("child1MessageValue", (Object)this.geKeyValuePairsAsString(keyValuesMap1));
                pair.put("child2MessageValue", (Object)this.geKeyValuePairsAsString(keyValuesMap2));
                messagesArray.put((Object)pair);
            }
            data.put("localizations", (Object)messagesArray);
            jsonResponse.setData(data);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            jsonResponse.addError("SERVER_ERROR", "Server error, please check logs.");
        }
        this.writeResponse(response, jsonResponse.toJSON().toString());
    }
}

