/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.localization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.cms.translation.IASGTranslationService;
import net.anotheria.anosite.cms.translation.TranslationServiceFactory;
import net.anotheria.anosite.config.LocalizationAutoTranslationConfig;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleDocument;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.maf.json.JSONResponse;
import net.anotheria.util.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/SpecificTranslateLocalizationBundle"})
@MultipartConfig
public class LocalizationBundleSpecificTranslationServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(LocalizationBundleSpecificTranslationServlet.class);
    private IASResourceDataService resourceDataService;
    private final IASGTranslationService translationService;
    private final LocalizationAutoTranslationConfig config = LocalizationAutoTranslationConfig.getInstance();

    public LocalizationBundleSpecificTranslationServlet() {
        this.translationService = new TranslationServiceFactory().create();
        try {
            this.resourceDataService = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException e) {
            log.error("Cannot initialize LocalizationBundleSpecificTranslationServlet");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getParameter("method");
        if (method.equals("translate")) {
            this.translate(req, resp);
        } else {
            this.saveTranslation(req, resp);
        }
    }

    private void translate(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONResponse jsonResponse = new JSONResponse();
        try {
            String bundleId = req.getParameter("bundleId");
            String localeFrom = req.getParameter("localeFrom");
            String input = req.getParameter("input");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)input)) {
                jsonResponse.addError("INPUT_ERROR", "input field is empty");
            } else {
                String languageFrom = null;
                for (Map.Entry<String, String> entry : this.config.getLanguagesMap().entrySet()) {
                    if (!entry.getKey().equals(localeFrom)) continue;
                    languageFrom = entry.getValue();
                }
                LocalizationBundleDocument bundle = (LocalizationBundleDocument)this.resourceDataService.getLocalizationBundle(bundleId);
                LinkedList<String> targetLocales = new LinkedList<String>();
                Enumeration keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (!key.contains("messages_") || key.equals("messages_" + localeFrom)) continue;
                    targetLocales.add(key.substring(key.indexOf("_") + 1));
                }
                HashMap<String, String> translatedMap = new HashMap<String, String>();
                for (String targetLocale : targetLocales) {
                    String language = this.config.getLanguagesMap().get(targetLocale);
                    if (language == null) {
                        jsonResponse.addError("CONFIG_ERROR", "Check ano-site-localization-auto-translation-config. Cannot find a normal language for locale: " + targetLocale);
                    }
                    String translatedContent = this.translationService.translate(languageFrom, language, input);
                    translatedMap.put(targetLocale, translatedContent);
                }
                JSONObject data = new JSONObject();
                data.put("success", true);
                data.put("results", translatedMap);
                jsonResponse.setData(data);
            }
        }
        catch (Exception any) {
            log.error(any.getMessage(), (Throwable)any);
            jsonResponse.addError("SERVER_ERROR", "Server error, please check logs.");
        }
        this.writeResponse(resp, jsonResponse.toJSON().toString());
    }

    private void saveTranslation(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONResponse jsonResponse = new JSONResponse();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String bundleId = req.getParameter("bundleId");
            String rawTranslatedMap = req.getParameter("map");
            HashMap<String, String> translatedMap = new HashMap<String, String>();
            ArrayNode rootNode = (ArrayNode)objectMapper.readTree(rawTranslatedMap);
            for (JsonNode jsonNode : rootNode) {
                ArrayNode value = (ArrayNode)jsonNode;
                String locale = value.get(0).asText().replace(":", "");
                String content = value.get(1).asText();
                translatedMap.put(locale, content);
            }
            LocalizationBundleDocument bundle = (LocalizationBundleDocument)this.resourceDataService.getLocalizationBundle(bundleId);
            for (Map.Entry entry : translatedMap.entrySet()) {
                String existingContent = bundle.getString("messages_" + (String)entry.getKey());
                existingContent = StringUtils.removeChar((String)existingContent, (char)'\r');
                Map existingContentMap = StringUtils.buildParameterMap((String)existingContent);
                String translatedContent = (String)entry.getValue();
                translatedContent = StringUtils.removeChar((String)translatedContent, (char)'\r');
                Map translatedContentMap = StringUtils.buildParameterMap((String)translatedContent);
                for (Map.Entry translatedEntry : translatedContentMap.entrySet()) {
                    if (existingContentMap.containsKey(translatedEntry.getKey())) {
                        existingContentMap.replace((String)translatedEntry.getKey(), (String)translatedEntry.getValue());
                        continue;
                    }
                    existingContentMap.put((String)translatedEntry.getKey(), (String)translatedEntry.getValue());
                }
                StringBuilder toSave = new StringBuilder();
                for (Map.Entry existingEntry : existingContentMap.entrySet()) {
                    toSave.append((String)existingEntry.getKey()).append("=").append((String)existingEntry.getValue()).append("\n");
                }
                bundle.setString("messages_" + (String)entry.getKey(), toSave.toString());
                this.resourceDataService.updateLocalizationBundle((LocalizationBundle)bundle);
            }
        }
        catch (Exception any) {
            log.error(any.getMessage(), (Throwable)any);
            jsonResponse.addError("SERVER_ERROR", "Server error, please check logs.");
        }
        this.writeResponse(resp, jsonResponse.toJSON().toString());
    }

    protected void writeResponse(HttpServletResponse response, String jsonString) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.write(jsonString);
        writer.flush();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
    }
}

