/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.localization;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.cms.translation.IASGTranslationService;
import net.anotheria.anosite.cms.translation.TranslationServiceFactory;
import net.anotheria.anosite.config.LocalizationAutoTranslationConfig;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleDocument;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.maf.json.JSONResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/TranslateLocalizationBundle"})
@MultipartConfig
public class LocalizationBundleTranslationServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(LocalizationBundleTranslationServlet.class);
    private IASResourceDataService resourceDataService;
    private final IASGTranslationService translationService;
    private final LocalizationAutoTranslationConfig config = LocalizationAutoTranslationConfig.getInstance();
    private final ExecutorService executorService;

    public LocalizationBundleTranslationServlet() {
        this.translationService = new TranslationServiceFactory().create();
        this.executorService = Executors.newFixedThreadPool(10);
        try {
            this.resourceDataService = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException e) {
            log.error("Cannot initialize LocalizationBundleTranslationServlet");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getParameter("method");
        if (method.equals("translate")) {
            this.translate(req, resp);
        } else {
            this.saveTranslation(req, resp);
        }
    }

    private void translate(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONResponse jsonResponse = new JSONResponse();
        try {
            String bundleId = req.getParameter("bundleId");
            String localeFrom = req.getParameter("localeFrom");
            String localeTo = req.getParameter("localeTo");
            if (localeFrom.equals(localeTo)) {
                jsonResponse.addError("INPUT_ERROR", "localeFrom equals to localeTo");
            } else {
                String languageFrom = null;
                String languageTo = null;
                for (Map.Entry<String, String> entry : this.config.getLanguagesMap().entrySet()) {
                    if (entry.getKey().equals(localeFrom)) {
                        languageFrom = entry.getValue();
                    }
                    if (!entry.getKey().equals(localeTo)) continue;
                    languageTo = entry.getValue();
                }
                if (languageFrom == null) {
                    jsonResponse.addError("CONFIG_ERROR", "Check ano-site-localization-auto-translation-config. Cannot find a normal language for locale: " + localeFrom);
                } else if (languageTo == null) {
                    jsonResponse.addError("CONFIG_ERROR", "Check ano-site-localization-auto-translation-config. Cannot find a normal language for locale: " + localeTo);
                } else {
                    String localizationBundleFrom = "messages_" + localeFrom;
                    String content = "";
                    LocalizationBundleDocument bundle = (LocalizationBundleDocument)this.resourceDataService.getLocalizationBundle(bundleId);
                    Enumeration keys = bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        if (!key.equals(localizationBundleFrom)) continue;
                        content = bundle.getString(key);
                        break;
                    }
                    if (StringUtils.isEmpty((CharSequence)content)) {
                        jsonResponse.addError("INPUT_ERROR", "Cannot find any content in for provided locale.");
                    }
                    StringBuilder translated = new StringBuilder();
                    List<String> contentLines = Arrays.asList(content.trim().split("\n"));
                    int chunkSize = 10;
                    int maxPages = contentLines.size() / chunkSize;
                    Vector translatedVector = new Vector();
                    CountDownLatch countDownLatch = new CountDownLatch(maxPages + 1);
                    int i = 0;
                    while (i <= maxPages) {
                        String finalLanguageFrom = languageFrom;
                        String finalLanguageTo = languageTo;
                        int finalI = i++;
                        Runnable chunkThread = () -> {
                            StringBuilder contentToTranslate = new StringBuilder();
                            int fromIndex = finalI * chunkSize;
                            int toIndex = finalI * chunkSize + chunkSize;
                            if (toIndex > contentLines.size()) {
                                toIndex = contentLines.size();
                            }
                            List subList = contentLines.subList(fromIndex, toIndex);
                            for (String s : subList) {
                                contentToTranslate.append(s).append("\n");
                            }
                            String translatedTemp = this.translationService.translate(finalLanguageFrom, finalLanguageTo, contentToTranslate.toString());
                            translatedVector.add(translatedTemp);
                            countDownLatch.countDown();
                        };
                        this.executorService.submit(chunkThread);
                    }
                    countDownLatch.await();
                    for (String s : translatedVector) {
                        String[] translatedLines;
                        for (String line : translatedLines = s.split("\n")) {
                            translated.append(line).append("\n");
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)translated)) {
                        JSONObject data = new JSONObject();
                        data.put("success", true);
                        data.put("originalText", (Object)content);
                        data.put("translatedText", (Object)translated);
                        jsonResponse.setData(data);
                    } else {
                        jsonResponse.addError("CANNOT_TRANSLATE", "Cannot translate a provided localization");
                    }
                }
            }
        }
        catch (Exception any) {
            log.error(any.getMessage(), (Throwable)any);
            jsonResponse.addError("SERVER_ERROR", "Server error, please check logs.");
        }
        this.writeResponse(resp, jsonResponse.toJSON().toString());
    }

    private void saveTranslation(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONResponse jsonResponse = new JSONResponse();
        try {
            String translatedText = req.getParameter("translatedText");
            String targetLocale = req.getParameter("targetLocale");
            String bundleId = req.getParameter("bundleId");
            LocalizationBundleDocument bundle = (LocalizationBundleDocument)this.resourceDataService.getLocalizationBundle(bundleId);
            String localizationBundleTo = "messages_" + targetLocale;
            bundle.putStringProperty(new StringProperty(localizationBundleTo, translatedText));
            this.resourceDataService.updateLocalizationBundle((LocalizationBundle)bundle);
        }
        catch (Exception any) {
            log.error(any.getMessage(), (Throwable)any);
            jsonResponse.addError("SERVER_ERROR", "Server error, please check logs.");
        }
        this.writeResponse(resp, jsonResponse.toJSON().toString());
    }

    protected void writeResponse(HttpServletResponse response, String jsonString) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.write(jsonString);
        writer.flush();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
    }
}

