/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.localization;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.anoplass.api.APICallContext;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.content.variables.VariablesUtility;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.anosite.localization.LocalizationEnvironment;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class LocalizationMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalizationMap.class);
    public static final String CALL_CONTEXT_SCOPE_NAME = LocalizationMap.class.getName();
    private Map<String, String> localizationBundles = new HashMap<String, String>();
    private IASResourceDataService resourceDataService;

    private LocalizationMap() {
        try {
            this.resourceDataService = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "Init IASResourceDataService failure", (Throwable)e);
            throw new RuntimeException("Init IASResourceDataService failure", e);
        }
    }

    private String getPrivateKey(LocalizationEnvironment environment, String key) {
        return environment.name() + "_" + key.trim();
    }

    public String getMessage(String key) {
        String message = this.localizationBundles.get(this.getPrivateKey(LocalizationEnvironment.BRAND, key));
        if (message == null) {
            message = this.localizationBundles.get(this.getPrivateKey(LocalizationEnvironment.ACTION, key));
        }
        if (message == null) {
            message = this.localizationBundles.get(this.getPrivateKey(LocalizationEnvironment.BOX, key));
        }
        if (message == null) {
            message = this.localizationBundles.get(this.getPrivateKey(LocalizationEnvironment.PAGE, key));
        }
        if (message == null) {
            message = this.localizationBundles.get(this.getPrivateKey(LocalizationEnvironment.TEMPLATE, key));
        }
        if (message == null) {
            message = this.localizationBundles.get(this.getPrivateKey(LocalizationEnvironment.SITE, key));
        }
        if (message == null) {
            message = this.localizationBundles.get(this.getPrivateKey(LocalizationEnvironment.RESOURCES, key));
        }
        message = VariablesUtility.replaceLocalizationBundleVariables(message);
        return message;
    }

    public void addLocalization(LocalizationEnvironment scope, Map<String, String> localization) {
        for (Map.Entry<String, String> loc : localization.entrySet()) {
            this.localizationBundles.put(this.getPrivateKey(scope, loc.getKey()), loc.getValue());
        }
    }

    public void addLocalizationBundles(LocalizationEnvironment scope, List<LocalizationBundle> bundles) {
        for (LocalizationBundle bundle : bundles) {
            this.addLocalizationBundle(scope, bundle);
        }
    }

    public void addLocalizationBundle(LocalizationEnvironment scope, LocalizationBundle bundle) {
        if (!StringUtils.isEmpty((String)bundle.getParentBundle())) {
            try {
                LocalizationBundle parentBundle = this.resourceDataService.getLocalizationBundle(bundle.getParentBundle());
                this.localizationBundles.putAll(this.parseBundle(scope, parentBundle));
            }
            catch (ASResourceDataServiceException e) {
                LOGGER.warn("Unable to get parent bundle. " + e.getMessage());
            }
        }
        this.localizationBundles.putAll(this.parseBundle(scope, bundle));
    }

    private Map<String, String> parseBundle(LocalizationEnvironment scope, LocalizationBundle bundle) {
        String[] lines;
        String toParse = bundle.getMessages();
        if (toParse == null) {
            LOGGER.error("LocalizationBundle " + bundle.getId() + ": message is null!");
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        toParse = StringUtils.removeChar((String)toParse, (char)'\r');
        for (String l : lines = StringUtils.tokenize((String)toParse, (char)'\n')) {
            if (StringUtils.isEmpty((String)l) || l.trim().startsWith("#")) continue;
            String escapedString = l.replace("\\=", "&#61;");
            if (!escapedString.contains("=")) {
                LOGGER.warn("Invalid format of LocalizationBundle with id " + bundle.getId() + " in line: <" + l + ">. Expected line format: <key=message>");
                continue;
            }
            String[] message = StringUtils.tokenize((String)escapedString, (char)'=');
            int length = message.length;
            if (length != 2 && length != 1 || message[0].isEmpty()) {
                LOGGER.warn("Invalid format of LocalizationBundle with id " + bundle.getId() + " in line: <" + l + ">. Expected line format: <key=message>");
                continue;
            }
            String key = message[0].replace("&#61;", "=");
            String value = length == 2 ? message[1].replace("&#61;", "=") : "";
            result.put(this.getPrivateKey(scope, key), value);
        }
        return result;
    }

    public static LocalizationMap getCurrentLocalizationMap() {
        LocalizationMap loc = (LocalizationMap)APICallContext.getCallContext().getAttribute(CALL_CONTEXT_SCOPE_NAME);
        if (loc != null) {
            return loc;
        }
        loc = new LocalizationMap();
        APICallContext.getCallContext().setAttribute(CALL_CONTEXT_SCOPE_NAME, (Object)loc);
        return loc;
    }
}

