/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.localization;

import java.util.List;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.asresourcedata.data.TextResource;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.anosite.localization.LocalizationMap;
import net.anotheria.asg.exception.ASGRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public enum LocalizationResolver {
    INSTANCE;

    private static final Logger LOGGER;
    private static IASResourceDataService resourceService;

    public String getLocalizedMessage(String key) {
        String message = LocalizationMap.getCurrentLocalizationMap().getMessage(key);
        if (message != null) {
            return message;
        }
        TextResource resource = this.getTextResourceByName(key);
        if (resource != null) {
            message = resource.getValue();
        }
        return message != null ? message : "Missing key: " + key;
    }

    protected TextResource getTextResourceByName(String key) throws RuntimeException {
        try {
            List resources = resourceService.getTextResourcesByProperty("name", (Object)key);
            if (resources == null || resources.size() == 0) {
                return null;
            }
            return (TextResource)resources.get(0);
        }
        catch (ASGRuntimeException e) {
            LOGGER.error("Error while loading localizations from ResourceDataService: ", (Throwable)e);
            throw new RuntimeException("Error while loading localizations from ResourceDataService: ", e);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(LocalizationResolver.class);
        try {
            resourceService = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "IASResourceDataService init failure", (Throwable)e);
        }
    }
}

