/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.shared;

import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="resource-servlet-mapping")
public class ResourceServletMappingConfig {
    private static final String SEPARATOR = "/";
    private static final String DEFAULT_IMAGE_SERVLET_MAPPING = "/cmsImage/";
    private static final String DEFAULT_FILE_SERVLET_MAPPING = "/cmsFile/";
    private static ResourceServletMappingConfig instance;
    @Configure
    private String imageServletMapping = "/cmsImage/";
    @Configure
    private String fileServletMapping = "/cmsFile/";

    public static synchronized ResourceServletMappingConfig getInstance() {
        if (instance == null) {
            instance = new ResourceServletMappingConfig();
            try {
                ConfigurationManager.INSTANCE.configure((Object)instance);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ResourceServletMappingConfig.class).warn("Configuration FAILED. Relying on defaults.", (Throwable)e);
            }
        }
        return instance;
    }

    private ResourceServletMappingConfig() {
    }

    public String getImageServletMapping() {
        return this.imageServletMapping;
    }

    public void setImageServletMapping(String imageServletMapping) {
        imageServletMapping = ((String)imageServletMapping).startsWith(SEPARATOR) ? imageServletMapping : SEPARATOR + (String)imageServletMapping;
        this.imageServletMapping = imageServletMapping = ((String)imageServletMapping).endsWith(SEPARATOR) ? imageServletMapping : (String)imageServletMapping + SEPARATOR;
    }

    public String getFileServletMapping() {
        return this.fileServletMapping;
    }

    public void setFileServletMapping(String fileServletMapping) {
        fileServletMapping = ((String)fileServletMapping).startsWith(SEPARATOR) ? fileServletMapping : SEPARATOR + (String)fileServletMapping;
        this.fileServletMapping = fileServletMapping = ((String)fileServletMapping).endsWith(SEPARATOR) ? fileServletMapping : (String)fileServletMapping + SEPARATOR;
    }

    public String toString() {
        return "ResourceServletMappingConfig{imageServletMapping='" + this.imageServletMapping + ", fileServletMapping='" + this.fileServletMapping + "}";
    }
}

