/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.shared.presentation.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.assiteconfig.data.FilteredIP;
import net.anotheria.anosite.gen.assiteconfig.service.IASSiteConfigService;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.util.StringUtils;
import net.anotheria.util.network.IPRange;
import net.anotheria.util.network.PlainIPFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class IPFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IPFilter.class);
    private IASSiteConfigService siteConfigService;
    private String maintenancePage;
    private String[] restrictedExtensions;
    private String[] restrictedPaths;

    public void init(FilterConfig config) throws ServletException {
        this.maintenancePage = config.getInitParameter("maintenancePage");
        String paramExt = config.getInitParameter("restrictedExtensions");
        this.restrictedExtensions = !StringUtils.isEmpty((String)paramExt) ? StringUtils.tokenize((String)paramExt, (char)',') : new String[]{};
        String paramPaths = config.getInitParameter("restrictedPaths");
        this.restrictedPaths = !StringUtils.isEmpty((String)paramPaths) ? StringUtils.tokenize((String)paramPaths, (char)',') : new String[]{};
        try {
            this.siteConfigService = (IASSiteConfigService)MetaFactory.get(IASSiteConfigService.class);
        }
        catch (MetaFactoryException e) {
            log.error(MarkerFactory.getMarker((String)"FATAL"), "Could not initialize IASSiteConfigService: ", (Throwable)e);
            throw new ServletException("Could not initialize IASSiteConfigService: " + e.getMessage());
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        if (!(sreq instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)sreq;
        if (!this.isRestrictedZoneReq(req)) {
            log.debug("Pass to not restricted zone: " + req.getRequestURL());
            chain.doFilter(sreq, sres);
            return;
        }
        try {
            String filterableIP = this.getFilterableIP(req);
            List<FilteredIP> filteredIPs = this.getFilteredIPs();
            log.debug("IP: " + filterableIP + ", FilteredIPs: " + filteredIPs);
            if (PlainIPFilter.mayPass((String)filterableIP, this.getIPRanges(filteredIPs, Allowance.ALLOWED))) {
                log.debug("IP is Allowed: Go to the next Filter in the chain");
                chain.doFilter(sreq, sres);
                return;
            }
            boolean mayNotPass = false;
            try {
                mayNotPass = PlainIPFilter.mayPass((String)filterableIP, this.getIPRanges(filteredIPs, Allowance.RESTRICTED));
            }
            catch (RuntimeException e) {
                log.warn("Exception parsing the ip, will not restrict.", (Throwable)e);
            }
            if (mayNotPass) {
                log.debug("IP is restricted: redirect to maintenance page");
                HttpServletResponse res = (HttpServletResponse)sres;
                String url = this.getMaintenancePageURL(req);
                if (url != null) {
                    res.sendRedirect(url);
                }
                res.setStatus(403);
                return;
            }
        }
        catch (ASGRuntimeException e) {
            log.error("doFilter", (Throwable)e);
            throw new ServletException("ASG Runtime Exception: " + e.getMessage());
        }
        log.debug("Current IP is not Filtered: just continue normal flow.");
        chain.doFilter(sreq, sres);
    }

    private String getFilterableIP(HttpServletRequest req) {
        return req.getRemoteAddr();
    }

    private List<FilteredIP> getFilteredIPs() throws ASGRuntimeException {
        return this.siteConfigService.getFilteredIPs();
    }

    private List<IPRange> getIPRanges(List<FilteredIP> filteredIPs, Allowance allowance) {
        int allowanceValue = allowance == Allowance.ALLOWED ? 2 : 1;
        ArrayList<IPRange> ret = new ArrayList<IPRange>();
        for (FilteredIP ip : filteredIPs) {
            if (allowanceValue != ip.getAllowance()) continue;
            try {
                ret.add(this.toIPRagne(ip));
            }
            catch (Exception e) {
                log.error("Could not parse FilteredIP: ", (Throwable)e);
            }
        }
        return ret;
    }

    private IPRange toIPRagne(FilteredIP filteredIP) {
        return new IPRange(filteredIP.getIpAddress(), filteredIP.getMask() != 0 ? filteredIP.getMask() : 32);
    }

    protected String getMaintenancePageURL(HttpServletRequest req) {
        if (StringUtils.isEmpty((String)this.maintenancePage)) {
            return null;
        }
        if (this.maintenancePage.startsWith("http://") || this.maintenancePage.startsWith("https://")) {
            return this.maintenancePage;
        }
        return req.getContextPath() + "/" + this.maintenancePage;
    }

    protected boolean isRestrictedZoneReq(HttpServletRequest req) {
        if (req.getRequestURI().equals(this.getMaintenancePageURL(req))) {
            return false;
        }
        String resourceURI = req.getRequestURI().substring(req.getContextPath().length() + 1);
        String path = StringUtils.getStringBefore((String)resourceURI, (String)"/");
        String ext = StringUtils.getStringAfter((String)resourceURI, (String)".");
        if (this.restrictedExtensions.length == 0 && this.restrictedPaths.length == 0) {
            return true;
        }
        for (String rPath : this.restrictedPaths) {
            if (!path.equals(rPath)) continue;
            return true;
        }
        for (String rExt : this.restrictedExtensions) {
            if (!ext.equals(rExt)) continue;
            return true;
        }
        return false;
    }

    private static enum Allowance {
        ALLOWED,
        RESTRICTED;

    }
}

