/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.shared.presentation.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.assitedata.data.RedirectUrl;
import net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException;
import net.anotheria.anosite.gen.assitedata.service.IASSiteDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class RedirectFilter
implements Filter {
    private IASSiteDataService siteDataService;
    private static Logger log = LoggerFactory.getLogger(RedirectFilter.class);
    private static final String CHAR = "/";

    public void destroy() {
    }

    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        String redirectUrl;
        if (!(sreq instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)sreq;
        Object url = req.getRequestURL().toString();
        String qs = req.getQueryString();
        if (qs != null && qs.length() > 0) {
            url = (String)url + qs;
        }
        if ((redirectUrl = this.resolveRedirectUrl((String)url)) == null) {
            chain.doFilter(sreq, sres);
            return;
        }
        log.info("Redirecting " + (String)url + " to " + redirectUrl);
        HttpServletResponse res = (HttpServletResponse)sres;
        res.setHeader("Location", redirectUrl);
        res.sendError(301, "Moved permanently");
    }

    public void init(FilterConfig arg0) throws ServletException {
        try {
            this.siteDataService = (IASSiteDataService)MetaFactory.get(IASSiteDataService.class);
        }
        catch (MetaFactoryException e) {
            log.error(MarkerFactory.getMarker((String)"FATAL"), "IASSiteDataService init failure", (Throwable)e);
            throw new ServletException("IASSiteDataService init failure", (Throwable)e);
        }
    }

    private String resolveRedirectUrl(String lookupUrl) {
        try {
            List urls = this.siteDataService.getRedirectUrls();
            for (RedirectUrl u : urls) {
                if (u.getIn() == null || !u.getIn().equals(lookupUrl) && !lookupUrl.equals(u.getIn() + CHAR)) continue;
                return u.getOut();
            }
        }
        catch (ASSiteDataServiceException e) {
            log.error("resolveRedirectUrl(" + lookupUrl + ")", (Throwable)e);
        }
        return null;
    }
}

