/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.shared.presentation.listener;

import java.util.List;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxHandlerDef;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxHandlerDefFactory;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxType;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxTypeFactory;
import net.anotheria.anosite.gen.ascustomdata.data.CustomGuardDef;
import net.anotheria.anosite.gen.ascustomdata.data.CustomGuardDefFactory;
import net.anotheria.anosite.gen.ascustomdata.service.IASCustomDataService;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxHandlerDef;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxHandlerDefFactory;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxType;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxTypeFactory;
import net.anotheria.anosite.gen.asgenericdata.data.GenericGuardDef;
import net.anotheria.anosite.gen.asgenericdata.data.GenericGuardDefFactory;
import net.anotheria.anosite.gen.asgenericdata.service.IASGenericDataService;
import net.anotheria.anosite.gen.aslayoutdata.data.PageLayout;
import net.anotheria.anosite.gen.aslayoutdata.data.PageLayoutFactory;
import net.anotheria.anosite.gen.aslayoutdata.service.IASLayoutDataService;
import net.anotheria.anosite.handler.BoxHandler;
import net.anotheria.anosite.handler.def.ImageBrowserHandler;
import net.anotheria.anosite.handler.def.RedirectImmediatelyHandler;
import net.anotheria.asg.exception.ASGRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public final class CMSSelfTest {
    private static IASGenericDataService genericDataService;
    private static IASCustomDataService customDataService;
    private static IASLayoutDataService layoutDataService;
    private static Logger log;

    public static final void performSelfTest() {
        log.info("%%% CMS SELF TEST STARTED %%%");
        log.info("CMS SELF TEST: Guards");
        CMSSelfTest.selfTestGuards();
        log.info("CMS SELF TEST: BoxTypes");
        CMSSelfTest.selfTestBoxTypes();
        log.info("CMS SELF TEST: BoxHandlers");
        CMSSelfTest.selfTestBoxHandlers();
        log.info("CMS SELF TEST: PageLayouts");
        CMSSelfTest.selfTestPageLayouts();
        log.info("%%% CMS SELF TEST FINISHED %%%");
    }

    private static void selfTestBoxTypes() {
        CMSSelfTest.ensureBoxTypeExists("GoogleAnalytics", "GoogleAnalytics");
        CMSSelfTest.ensureBoxTypeExists("GoogleAnalyticsGA", "GoogleAnalyticsGA");
        CMSSelfTest.ensureBoxTypeExists("IfSet", "IfSet");
        CMSSelfTest.ensureBoxTypeExists("Plain", "Plain");
        CMSSelfTest.ensureBoxTypeExists("Styled", "Styled");
        CMSSelfTest.ensureBoxTypeExists("TextBox", "TextBox");
        CMSSelfTest.ensureBoxTypeExists("CSSLink", "CSSLink");
        CMSSelfTest.ensureBoxTypeExists("JSLink", "JSLink");
    }

    private static void selfTestBoxHandlers() {
        CMSSelfTest.ensureBoxHandlerExists("RedirectImmediatelyHandler", RedirectImmediatelyHandler.class);
        CMSSelfTest.ensureBoxHandlerExists("ImageBrowser", ImageBrowserHandler.class);
    }

    private static void selfTestGuards() {
        CMSSelfTest.ensureGuardExists("DONTSHOW", "net.anotheria.anosite.guard.DisableTargetGuard");
        CMSSelfTest.ensureGuardExists("CMSLogedInGuard", "net.anotheria.anosite.guard.CMSLogedInGuard");
        CMSSelfTest.ensureGuardExists("CMSLoggedOut", "net.anotheria.anosite.guard.CMSLoggedOutGuard");
        CMSSelfTest.ensureGuardExists("InEditModeGuard", "net.anotheria.anosite.guard.InEditModeGuard");
        CMSSelfTest.ensureGuardExists("NotInEditModeGuard", "net.anotheria.anosite.guard.NotInEditModeGuard");
        CMSSelfTest.ensureGuardExists("System is Develop", "net.anotheria.anosite.guard.SystemIsDevelopGuard");
        CMSSelfTest.ensureGuardExists("System is Production", "net.anotheria.anosite.guard.SystemIsProductionGuard");
        CMSSelfTest.ensureGuardExists("System is Test", "net.anotheria.anosite.guard.SystemIsTestGuard");
        CMSSelfTest.ensureGuardExists("RussianContextLanguage", "net.anotheria.anosite.guard.ContextLanguageIsRussianGuard");
        CMSSelfTest.ensureGuardExists("GermanContextLanguage", "net.anotheria.anosite.guard.ContextLanguageIsGermanGuard");
        CMSSelfTest.ensureGuardExists("EnglishContextLanguage", "net.anotheria.anosite.guard.ContextLanguageIsEnglishGuard");
    }

    private static void selfTestPageLayouts() {
        CMSSelfTest.ensurePageLayoutExists("LayoutPlainHtml", "LayoutPlainHtml", "Layout for text/html pages. Intialy doesn't have any HTML markup. Use header/column1/column2/column3/footer fro addidng content boxes.");
        CMSSelfTest.ensurePageLayoutExists("LayoutPlainText", "LayoutPlainText", "Layout for text/plain pages such a robots.txt or xml files. Use header/column1/column2/column3/footer fro addidng content boxes.");
    }

    private static void ensureGuardExists(String name, String clazz) {
        try {
            List defs = genericDataService.getGenericGuardDefsByProperty("name", (Object)name);
            if (defs.size() > 0) {
                return;
            }
            log.info("%%% Creating GenericDataDef " + name + ", clazz: " + clazz);
            GenericGuardDef newDef = GenericGuardDefFactory.createGenericGuardDef();
            newDef.setName(name);
            newDef.setClazz(clazz);
            genericDataService.createGenericGuardDef(newDef);
            log.info("%%% --> done, created " + newDef);
        }
        catch (ASGRuntimeException e) {
            log.error("ensureGuardExists(" + name + ", " + clazz + ")", (Throwable)e);
        }
    }

    private static void ensureBoxHandlerExists(String name, Class<? extends BoxHandler> clazz) {
        CMSSelfTest.ensureBoxHandlerExists(name, clazz.getName());
    }

    private static void ensureBoxHandlerExists(String name, String clazz) {
        try {
            List defs = genericDataService.getGenericBoxHandlerDefsByProperty("name", (Object)name);
            if (defs.size() > 0) {
                return;
            }
            log.info("%%% Creating GenericBoxHandlerDef " + name + ", clazz: " + clazz);
            GenericBoxHandlerDef newDef = GenericBoxHandlerDefFactory.createGenericBoxHandlerDef();
            newDef.setName(name);
            newDef.setClazz(clazz);
            genericDataService.createGenericBoxHandlerDef(newDef);
            log.info("%%% --> done, created " + newDef);
        }
        catch (ASGRuntimeException e) {
            log.error("ensureBoxHandlerExists(" + name + ", " + clazz + ")", (Throwable)e);
        }
    }

    private static void ensureBoxTypeExists(String name, String rendererpage) {
        try {
            List types = genericDataService.getGenericBoxTypesByProperty("name", (Object)name);
            if (types.size() > 0) {
                return;
            }
            log.info("%%% Creating GenericBoxType " + name + ", rendererpage: " + rendererpage);
            GenericBoxType newType = GenericBoxTypeFactory.createGenericBoxType();
            newType.setName(name);
            newType.setRendererpage(rendererpage);
            genericDataService.createGenericBoxType(newType);
            log.info("%%% --> done, created " + newType);
        }
        catch (ASGRuntimeException e) {
            log.error("ensureBoxTypeExists(" + name + ", " + rendererpage + ")", (Throwable)e);
        }
    }

    public static void ensureCustomGuardExists(String name, String clazz) {
        try {
            List defs = customDataService.getCustomGuardDefsByProperty("name", (Object)name);
            if (defs.size() > 0) {
                return;
            }
            log.info("%%% Creating CustomDataDef " + name + ", clazz: " + clazz);
            CustomGuardDef newDef = CustomGuardDefFactory.createCustomGuardDef();
            newDef.setName(name);
            newDef.setClazz(clazz);
            customDataService.createCustomGuardDef(newDef);
            log.info("%%% --> done, created " + newDef);
        }
        catch (ASGRuntimeException e) {
            log.error("ensureGuardExists(" + name + ", " + clazz + ")", (Throwable)e);
        }
    }

    public static void ensureCustomBoxHandlerExists(String name, String clazz) {
        try {
            List defs = customDataService.getCustomBoxHandlerDefsByProperty("name", (Object)name);
            if (defs.size() > 0) {
                return;
            }
            log.info("%%% Creating CustomBoxHandlerDef " + name + ", clazz: " + clazz);
            CustomBoxHandlerDef newDef = CustomBoxHandlerDefFactory.createCustomBoxHandlerDef();
            newDef.setName(name);
            newDef.setClazz(clazz);
            customDataService.createCustomBoxHandlerDef(newDef);
            log.info("%%% --> done, created " + newDef);
        }
        catch (ASGRuntimeException e) {
            log.error("ensureBoxHandlerExists(" + name + ", " + clazz + ")", (Throwable)e);
        }
    }

    public static void ensureCustomBoxTypeExists(String name, String rendererpage) {
        try {
            List types = customDataService.getCustomBoxTypesByProperty("name", (Object)name);
            if (types.size() > 0) {
                return;
            }
            log.info("%%% Creating CustomBoxType " + name + ", rendererpage: " + rendererpage);
            CustomBoxType newType = CustomBoxTypeFactory.createCustomBoxType();
            newType.setName(name);
            newType.setRendererpage(rendererpage);
            customDataService.createCustomBoxType(newType);
            log.info("%%% --> done, created " + newType);
        }
        catch (ASGRuntimeException e) {
            log.error("ensureBoxTypeExists(" + name + ", " + rendererpage + ")", (Throwable)e);
        }
    }

    public static void ensurePageLayoutExists(String name, String rendererpage, String description) {
        try {
            List layouts = layoutDataService.getPageLayoutsByProperty("name", (Object)name);
            if (layouts.size() > 0) {
                return;
            }
            log.info("%%% Creating PageLayout " + name + ", rendererpage: " + rendererpage);
            PageLayout newPageLayout = PageLayoutFactory.createPageLayout();
            newPageLayout.setName(name);
            newPageLayout.setLayoutpage(rendererpage);
            newPageLayout.setDescription(description);
            layoutDataService.createPageLayout(newPageLayout);
            log.info("%%% --> done, created " + newPageLayout);
        }
        catch (ASGRuntimeException e) {
            log.error("ensurePageLayoutExists(" + name + ", " + rendererpage + ")", (Throwable)e);
        }
    }

    static {
        log = LoggerFactory.getLogger(CMSSelfTest.class);
        try {
            genericDataService = (IASGenericDataService)MetaFactory.get(IASGenericDataService.class);
            customDataService = (IASCustomDataService)MetaFactory.get(IASCustomDataService.class);
            layoutDataService = (IASLayoutDataService)MetaFactory.get(IASLayoutDataService.class);
        }
        catch (MetaFactoryException e) {
            log.error(MarkerFactory.getMarker((String)"FATAL"), "ASG services init failure", (Throwable)e);
        }
    }
}

