/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.tags.resource;

import jakarta.servlet.jsp.JspException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.content.servlet.resource.type.ResourceReadType;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.asg.data.DataObject;
import net.anotheria.tags.BaseTagSupport;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public abstract class AbstractResourceTag
extends BaseTagSupport {
    private static IASResourceDataService service;
    private static final Logger LOG;
    private static final String SEPARATOR = "/";
    private String selectPropertyName = ReadPropertyType.DEFAULT.getValue();
    private String propertyValue;
    private boolean addContextPath = true;
    private String resultPropertyName = ResultPropertyType.DEFAULT.getValue();

    protected static IASResourceDataService getResourceDataService() {
        return service;
    }

    protected static Logger getLog() {
        return LOG;
    }

    protected ReadPropertyType getSelectType() {
        if (StringUtils.isEmpty((String)this.selectPropertyName)) {
            return ReadPropertyType.DEFAULT;
        }
        return ReadPropertyType.getPropertyNameByValue(this.selectPropertyName);
    }

    public void setSelectPropertyName(String aSelectPropertyName) {
        this.selectPropertyName = aSelectPropertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    public boolean isAddContextPath() {
        return this.addContextPath;
    }

    public void setAddContextPath(boolean addContextPath) {
        this.addContextPath = addContextPath;
    }

    protected ResultPropertyType getResultType() {
        if (StringUtils.isEmpty((String)this.resultPropertyName)) {
            return ResultPropertyType.DEFAULT;
        }
        return ResultPropertyType.getPropertyNameByValue(this.resultPropertyName);
    }

    public void setResultPropertyName(String aResultPropertyName) {
        this.resultPropertyName = aResultPropertyName;
    }

    public String getSelectPropertyName() {
        return this.selectPropertyName;
    }

    public String getResultPropertyName() {
        return this.resultPropertyName;
    }

    public int doEndTag() throws JspException {
        if (StringUtils.isEmpty((String)this.getPropertyValue())) {
            throw new JspException("required attribute - propertyValue is missing");
        }
        if (this.getSelectType() == ReadPropertyType.DIRECT_FILE_NAME) {
            this.write(this.getResourcePath() + this.propertyValue);
            return 0;
        }
        this.write(this.getOutputData());
        return 0;
    }

    private String getOutputData() throws JspException {
        switch (this.getResultType()) {
            case DOCUMENT_TITLE: {
                return this.getTitleFromDocument(this.getDocument());
            }
            case DOCUMENT_ALIAS: {
                return this.getAliasFromDocument(this.getDocument());
            }
            case DOCUMENT_ALT: {
                return this.getAltFromDocument(this.getDocument());
            }
            case FILE_OR_IMAGE: {
                StringBuilder buf = new StringBuilder();
                buf.append(this.getResourcePath()).append(this.getSelectType().getValue()).append(SEPARATOR).append(this.getPropertyValue());
                return buf.toString();
            }
        }
        String message = this.getResultPropertyName() + " not supported for " + ((Object)((Object)this)).getClass().getName() + "! Refer to implementation Please!";
        LOG.warn(message);
        throw new RuntimeException(message);
    }

    protected abstract String getTitleFromDocument(DataObject var1);

    protected abstract String getAliasFromDocument(DataObject var1);

    protected abstract String getAltFromDocument(DataObject var1);

    protected abstract String getResourcePath();

    protected abstract DataObject getDocument() throws JspException;

    static {
        LOG = LoggerFactory.getLogger(AbstractResourceTag.class);
        try {
            service = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException e) {
            LOG.error(MarkerFactory.getMarker((String)"FATAL"), "IASResourceDataService init failure", (Throwable)e);
        }
    }

    protected static enum ReadPropertyType {
        DOCUMENT_ID(ResourceReadType.BY_ID.getValue()),
        DOCUMENT_NAME(ResourceReadType.BY_NAME.getValue()),
        DIRECT_FILE_NAME(ResourceReadType.BY_DIRECT_FILE_NAME.getValue());

        protected static final ReadPropertyType DEFAULT;
        private String value;

        private ReadPropertyType(String aValue) {
            this.value = aValue;
        }

        public String getValue() {
            return this.value;
        }

        public static ReadPropertyType getPropertyNameByValue(String val) {
            for (ReadPropertyType documentSelectProperty : ReadPropertyType.values()) {
                if (!documentSelectProperty.getValue().equals(val)) continue;
                return documentSelectProperty;
            }
            LoggerFactory.getLogger(ReadPropertyType.class).error("No ReadPropertyType found with value[" + val + "], relying on defaults!");
            return DEFAULT;
        }

        static {
            DEFAULT = DOCUMENT_NAME;
        }
    }

    protected static enum ResultPropertyType {
        DOCUMENT_TITLE("title"),
        DOCUMENT_ALIAS("alias"),
        DOCUMENT_ALT("alt"),
        FILE_OR_IMAGE("file_or_image");

        protected static final ResultPropertyType DEFAULT;
        private String value;

        private ResultPropertyType(String aValue) {
            this.value = aValue;
        }

        public String getValue() {
            return this.value;
        }

        public static ResultPropertyType getPropertyNameByValue(String val) {
            for (ResultPropertyType documentSelectProperty : ResultPropertyType.values()) {
                if (!documentSelectProperty.getValue().equals(val)) continue;
                return documentSelectProperty;
            }
            LoggerFactory.getLogger(ResultPropertyType.class).error("No ResultPropertyType found with value[" + val + "], relying on defaults!");
            return DEFAULT;
        }

        static {
            DEFAULT = FILE_OR_IMAGE;
        }
    }
}

