/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.tags.resource.file;

import jakarta.servlet.jsp.JspException;
import java.util.List;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anosite.gen.asresourcedata.data.FileLink;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;
import net.anotheria.anosite.shared.ResourceServletMappingConfig;
import net.anotheria.anosite.tags.resource.AbstractResourceTag;
import net.anotheria.asg.data.DataObject;

public class CmsFileTag
extends AbstractResourceTag {
    @Override
    protected String getTitleFromDocument(DataObject document) {
        if (!(document instanceof FileLink)) {
            return "FileLink " + this.getSelectType().getValue() + "[" + this.getPropertyValue() + "] ::: missing";
        }
        return ((FileLink)FileLink.class.cast(document)).getTitle();
    }

    @Override
    protected String getAliasFromDocument(DataObject document) {
        throw new RuntimeException(this.getResultPropertyName() + " not supported for CmsFileTag! Refer to implementation Please!");
    }

    @Override
    protected String getResourcePath() {
        String contextPath = this.pageContext.getServletContext().getContextPath();
        String servletMapping = ResourceServletMappingConfig.getInstance().getFileServletMapping();
        if (!contextPath.isEmpty() && this.isAddContextPath()) {
            return contextPath + servletMapping;
        }
        return servletMapping;
    }

    @Override
    protected String getAltFromDocument(DataObject document) {
        throw new RuntimeException(this.getResultPropertyName() + " not supported for CmsFileTag! Refer to implementation Please!");
    }

    @Override
    protected DataObject getDocument() throws JspException {
        FileLink document = null;
        switch (this.getSelectType()) {
            case DOCUMENT_ID: {
                try {
                    document = CmsFileTag.getResourceDataService().getFileLink(this.getPropertyValue());
                    if (document == null) {
                        CmsFileTag.getLog().warn("FileLink " + this.getSelectType().getValue() + "[" + this.getPropertyValue() + "] ::: missing");
                    }
                    return document;
                }
                catch (NoSuchDocumentException nSde) {
                    CmsFileTag.getLog().warn("FileLink " + this.getSelectType().getValue() + "[" + this.getPropertyValue() + "] ::: missing");
                    return null;
                }
                catch (ASResourceDataServiceException e) {
                    CmsFileTag.getLog().warn("ASResourceDataService failed", (Throwable)e);
                    throw new JspException("Internal server error", (Throwable)e);
                }
            }
            case DOCUMENT_NAME: {
                try {
                    List files = CmsFileTag.getResourceDataService().getFileLinksByProperty("name", (Object)this.getPropertyValue());
                    if (files != null && !files.isEmpty()) {
                        document = (FileLink)files.get(0);
                    }
                    if (document == null) {
                        CmsFileTag.getLog().warn("FileLink " + this.getSelectType().getValue() + "[" + this.getPropertyValue() + "] ::: missing");
                    }
                    return document;
                }
                catch (ASResourceDataServiceException e) {
                    CmsFileTag.getLog().warn("ASResourceDataService failed", (Throwable)e);
                    throw new JspException("Internal server error", (Throwable)e);
                }
            }
        }
        throw new RuntimeException(this.getSelectPropertyName() + " not supported in CmsFileTag! Refer to implementation Please!");
    }
}

