/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.tags.resource.image;

import jakarta.servlet.jsp.JspException;
import java.util.List;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;
import net.anotheria.anosite.shared.ResourceServletMappingConfig;
import net.anotheria.anosite.tags.resource.AbstractResourceTag;
import net.anotheria.asg.data.DataObject;

public class CmsImageTag
extends AbstractResourceTag {
    @Override
    protected String getTitleFromDocument(DataObject document) {
        if (!(document instanceof Image)) {
            return "Image " + this.getSelectType().getValue() + "[" + this.getPropertyValue() + "] ::: missing";
        }
        return ((Image)Image.class.cast(document)).getTitle();
    }

    @Override
    protected String getAliasFromDocument(DataObject document) {
        if (!(document instanceof Image)) {
            return "Image " + this.getSelectType().getValue() + "[" + this.getPropertyValue() + "] ::: missing";
        }
        return ((Image)Image.class.cast(document)).getAlias();
    }

    @Override
    protected String getAltFromDocument(DataObject document) {
        if (!(document instanceof Image)) {
            return "Image " + this.getSelectType().getValue() + "[" + this.getPropertyValue() + "] ::: missing";
        }
        String altValue = ((Image)Image.class.cast(document)).getAlt();
        if (altValue.isEmpty()) {
            return ((Image)Image.class.cast(document)).getTitle();
        }
        return altValue;
    }

    @Override
    protected String getResourcePath() {
        String contextPath = this.pageContext.getServletContext().getContextPath();
        String servletMapping = ResourceServletMappingConfig.getInstance().getImageServletMapping();
        if (!contextPath.isEmpty() && this.isAddContextPath()) {
            return contextPath + servletMapping;
        }
        return servletMapping;
    }

    @Override
    protected DataObject getDocument() throws JspException {
        Image document = null;
        switch (this.getSelectType()) {
            case DOCUMENT_ID: {
                try {
                    document = CmsImageTag.getResourceDataService().getImage(this.getPropertyValue());
                    if (document == null) {
                        CmsImageTag.getLog().warn("Image " + this.getSelectType().getValue() + "[" + this.getPropertyValue() + "] ::: missing");
                    }
                    return document;
                }
                catch (NoSuchDocumentException nSde) {
                    CmsImageTag.getLog().warn("Image " + this.getSelectType().getValue() + "[" + this.getPropertyValue() + "] ::: missing");
                    return null;
                }
                catch (ASResourceDataServiceException e) {
                    CmsImageTag.getLog().warn("ASResourceDataService failed", (Throwable)e);
                    throw new JspException("Internal server error", (Throwable)e);
                }
            }
            case DOCUMENT_NAME: {
                try {
                    List images = CmsImageTag.getResourceDataService().getImagesByProperty("name", (Object)this.getPropertyValue());
                    if (images != null && !images.isEmpty()) {
                        document = (Image)images.get(0);
                    }
                    if (document == null) {
                        CmsImageTag.getLog().warn("Image " + this.getSelectType().getValue() + "[" + this.getPropertyValue() + "] ::: missing");
                    }
                    return document;
                }
                catch (ASResourceDataServiceException e) {
                    CmsImageTag.getLog().warn("ASResourceDataService failed", (Throwable)e);
                    throw new JspException("Internal server error", (Throwable)e);
                }
            }
        }
        throw new RuntimeException(this.getSelectPropertyName() + " not supported in CmsImageTag! Refer to implementation Please!");
    }
}

