/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.wizard;

import java.util.Map;
import org.slf4j.LoggerFactory;

public enum WizardCommand {
    CANCEL("cancel"),
    FINISH("finish"),
    PREVIOUS("previous"),
    NEXT("next"),
    NAVIGATE_TO("navigate_to");

    public static final WizardCommand DEFAULT_COMMAND;
    private String commandTitle;

    private WizardCommand(String aCommandTitle) {
        this.commandTitle = aCommandTitle;
    }

    public String getCommandTitle() {
        return this.commandTitle;
    }

    public String toString() {
        return this.commandTitle;
    }

    public static WizardCommand getCommandByValue(Map<String, String[]> parameters) {
        for (String param : parameters.keySet()) {
            for (WizardCommand button : WizardCommand.values()) {
                if (!param.equals(button.getCommandTitle())) continue;
                return button;
            }
        }
        LoggerFactory.getLogger(WizardCommand.class).debug("Command not found! Relying on defaults!");
        return DEFAULT_COMMAND;
    }

    public static WizardCommand getCommandByValue(String command) {
        for (WizardCommand wizCommand : WizardCommand.values()) {
            if (!wizCommand.getCommandTitle().equalsIgnoreCase(command)) continue;
            return wizCommand;
        }
        LoggerFactory.getLogger(WizardCommand.class).debug("Command not found! Relying on defaults! command[" + command + "]");
        return DEFAULT_COMMAND;
    }

    static {
        DEFAULT_COMMAND = NEXT;
    }
}

