/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.wizard.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.anoplass.api.APIInitException;
import net.anotheria.anoplass.api.AbstractAPIImpl;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDef;
import net.anotheria.anosite.gen.aswizarddata.service.ASWizardDataServiceException;
import net.anotheria.anosite.gen.aswizarddata.service.IASWizardDataService;
import net.anotheria.anosite.gen.aswizarddata.service.WizardDefNotFoundInASWizardDataServiceException;
import net.anotheria.anosite.wizard.WizardCommand;
import net.anotheria.anosite.wizard.api.WizardAO;
import net.anotheria.anosite.wizard.api.WizardAPI;
import net.anotheria.anosite.wizard.api.WizardStepAO;
import net.anotheria.anosite.wizard.api.exception.WizardAPIException;
import net.anotheria.anosite.wizard.api.exception.WizardAPIFirstStepException;
import net.anotheria.anosite.wizard.api.exception.WizardAPILastStepException;
import net.anotheria.anosite.wizard.api.exception.WizardNotFoundException;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseWizardAPIImpl
extends AbstractAPIImpl
implements WizardAPI {
    private static final Logger LOG = LoggerFactory.getLogger(BaseWizardAPIImpl.class);
    public static final String WIZARD_ATTRIBUTE_SUFFIX = "_wizardData";
    public static final String ALLOWED_WIZARD_STEP_COMMANDS_ATTRIBUTE = "allowedWizardStepCommands";
    private IASWizardDataService wizardDataService;

    public void init() throws APIInitException {
        super.init();
        try {
            this.wizardDataService = (IASWizardDataService)MetaFactory.get(IASWizardDataService.class);
        }
        catch (MetaFactoryException e) {
            throw new APIInitException("WizardAPI init failed", (Exception)((Object)e));
        }
    }

    @Override
    public WizardAO getWizardByName(String wizardName) throws WizardAPIException {
        if (StringUtils.isEmpty((String)wizardName)) {
            throw new IllegalArgumentException("Wizard name is illegal");
        }
        try {
            List wizards = this.wizardDataService.getWizardDefsByProperty("name", (Object)wizardName);
            if (wizards == null || wizards.isEmpty()) {
                throw new WizardNotFoundException(wizardName);
            }
            return this.toWizardAO((WizardDef)wizards.get(0));
        }
        catch (ASWizardDataServiceException e) {
            LOG.error("getWizardByName(" + wizardName + ")", (Throwable)e);
            throw new WizardAPIException("Backend failure", (Exception)((Object)e));
        }
    }

    @Override
    public WizardAO getWizard(String wizardId) throws WizardAPIException {
        if (StringUtils.isEmpty((String)wizardId)) {
            throw new IllegalArgumentException("WizardId is illegal");
        }
        try {
            return this.toWizardAO(this.wizardDataService.getWizardDef(wizardId));
        }
        catch (WizardDefNotFoundInASWizardDataServiceException wDnfe) {
            throw new WizardNotFoundException(wizardId);
        }
        catch (ASWizardDataServiceException e) {
            LOG.error("getWizard(" + wizardId + ")", (Throwable)e);
            throw new WizardAPIException("Backend failure", (Exception)((Object)e));
        }
    }

    @Override
    public String getCurrentStepPageId(String wizardId) throws WizardAPIException {
        return this.getCurrentStep(wizardId).getPagexId();
    }

    @Override
    public WizardStepAO getCurrentStep(String wizardId) throws WizardAPIException {
        WizardAO wizard = this.getWizard(wizardId);
        if (wizard.getWizardSteps().isEmpty()) {
            LOG.warn(" getCurrentStep(" + wizardId + ") - Steps are not properly configured");
            throw new WizardAPIException(" getCurrentStep(" + wizardId + ") - Steps are not properly configured");
        }
        WizardData data = this.getDataFromSession(wizardId);
        if (data == null) {
            data = this.createWizardData(wizard);
        }
        return data.getCurrentStep();
    }

    @Override
    public List<WizardStepAO> getCompletedSteps(String wizardId) throws WizardAPIException {
        WizardData data = this.getDataFromSession(wizardId);
        if (data == null) {
            LOG.warn("getCompletedSteps(" + wizardId + ") . There is no data found. Suppose it was just removed!");
            throw new WizardAPIException("getCompletedSteps(" + wizardId + ") . There is no data found. Suppose it was just removed!");
        }
        return data.getCompletedSteps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WizardStepAO adjustToNextStep(String wizardId) throws WizardAPIException {
        WizardStepAO currentStep;
        WizardData data = this.getDataFromSession(wizardId);
        if (data == null) {
            LOG.warn("adjustToNextStep(" + wizardId + ") . There is no data found.");
            throw new WizardAPIException("adjustToNextStep(" + wizardId + ") . There is no data found.");
        }
        WizardAO wizard = this.getWizard(wizardId);
        if (this.isLastStep(wizard, currentStep = this.getCurrentStep(wizardId))) {
            throw new WizardAPILastStepException(wizardId, currentStep.getPagexId(), currentStep.getStepIndex());
        }
        try {
            if (!this.isCommandAllowed(wizard.getId(), currentStep.getPagexId(), WizardCommand.NEXT)) {
                LOG.debug("Next step is not allowed! Stay on current!");
                WizardStepAO wizardStepAO = currentStep;
                return wizardStepAO;
            }
            int nextStepIndex = currentStep.getStepIndex() + 1;
            data.addCompletedStep(data.getCurrentStep());
            WizardStepAO nextStep = wizard.getWizardSteps().get(nextStepIndex);
            data.setCurrentStep(nextStep);
            WizardStepAO wizardStepAO = nextStep;
            return wizardStepAO;
        }
        finally {
            this.cleanAllowedCommands(wizard.getId(), currentStep.getPagexId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WizardStepAO adjustToPreviousStep(String wizardId) throws WizardAPIException {
        WizardData data = this.getDataFromSession(wizardId);
        if (data == null) {
            LOG.warn("adjustToPreviousStep(" + wizardId + ") . There is no data found.");
            throw new WizardAPIException("adjustToPreviousStep(" + wizardId + ") . There is no data found.");
        }
        WizardStepAO currentStep = this.getCurrentStep(wizardId);
        WizardAO wizard = this.getWizard(wizardId);
        if (this.isFirstStep(wizard, currentStep)) {
            throw new WizardAPIFirstStepException(wizardId, currentStep.getPagexId(), currentStep.getStepIndex());
        }
        try {
            if (!this.isCommandAllowed(wizard.getId(), currentStep.getPagexId(), WizardCommand.PREVIOUS)) {
                LOG.debug("Previous step is not allowed! Stay on current!");
                WizardStepAO wizardStepAO = currentStep;
                return wizardStepAO;
            }
            int prevStepIndex = currentStep.getStepIndex() - 1;
            WizardStepAO prevStep = wizard.getWizardSteps().get(prevStepIndex);
            data.setCurrentStep(prevStep);
            WizardStepAO wizardStepAO = prevStep;
            return wizardStepAO;
        }
        finally {
            this.cleanAllowedCommands(wizard.getId(), currentStep.getPagexId());
        }
    }

    @Override
    public WizardStepAO adjustToStep(String wizardId, int stepIndex) throws WizardAPIException {
        WizardAO wizard = this.getWizard(wizardId);
        WizardStepAO currentStep = this.getCurrentStep(wizardId);
        if (!this.navigateToAllowed(wizard, stepIndex)) {
            LOG.debug("Navigate to step is not allowed! Stay on current!");
            return currentStep;
        }
        if (currentStep.getStepIndex() == stepIndex) {
            return currentStep;
        }
        WizardData data = this.getDataFromSession(wizardId);
        if (data == null) {
            LOG.warn("adjustToStep(" + wizardId + ", " + stepIndex + ") . There is no data found.");
            throw new WizardAPIException("adjustToStep(" + wizardId + ", " + stepIndex + ") . There is no data found.");
        }
        WizardStepAO step = wizard.getWizardSteps().get(stepIndex);
        data.setCurrentStep(step);
        return step;
    }

    private boolean navigateToAllowed(WizardAO wizard, int stepIndex) throws WizardAPIException {
        if (stepIndex < 0 || stepIndex >= wizard.getWizardSteps().size()) {
            throw new IllegalArgumentException("Step index is illegal " + stepIndex);
        }
        WizardStepAO stepAO = wizard.getWizardSteps().get(stepIndex);
        List<WizardStepAO> passed = this.getCompletedSteps(wizard.getId());
        if (!passed.contains(stepAO) && !this.isCommandAllowed(wizard.getId(), stepAO.getPagexId(), WizardCommand.NAVIGATE_TO)) {
            this.log.debug(stepAO + "is not passed! Navigation is not allowed!");
            return false;
        }
        this.log.debug("Navigating to allowed " + stepAO);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finishWizard(WizardAO wizard) throws WizardAPIException {
        if (wizard == null) {
            throw new IllegalArgumentException("Incorrect incoming param");
        }
        WizardStepAO current = this.getCurrentStep(wizard.getId());
        try {
            if (this.isLastStep(wizard, current) && this.isCommandAllowed(wizard.getId(), current.getPagexId(), WizardCommand.FINISH)) {
                this.removeWizardData(wizard.getId());
                LOG.debug(wizard + " finished");
                boolean bl = true;
                return bl;
            }
            LOG.debug("Wizard Finish is not allowed " + wizard + "isLastStep [" + this.isLastStep(wizard, current) + "]  commandAllowed[" + this.isCommandAllowed(wizard.getId(), current.getPagexId(), WizardCommand.FINISH) + "]");
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanAllowedCommands(wizard.getId(), current.getPagexId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelWizard(WizardAO wizard) throws WizardAPIException {
        if (wizard == null) {
            throw new IllegalArgumentException("Incorrect incoming param");
        }
        WizardStepAO current = this.getCurrentStep(wizard.getId());
        try {
            if (this.isCommandAllowed(wizard.getId(), current.getPagexId(), WizardCommand.CANCEL)) {
                this.removeWizardData(wizard.getId());
                LOG.debug(wizard + " canceled on step :[" + current + "]");
                boolean bl = true;
                return bl;
            }
            LOG.debug(wizard + " cancel not allowed on step :[" + current + "]");
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanAllowedCommands(wizard.getId(), current.getWizardId());
        }
    }

    @Override
    public void allowNextStepNavigation(WizardAO wizard, WizardStepAO wizardStep) {
        this.allowCommand(wizard.getId(), wizardStep.getPagexId(), WizardCommand.NEXT);
    }

    @Override
    public void allowPreviousStepNavigation(WizardAO wizard, WizardStepAO wizardStep) {
        this.allowCommand(wizard.getId(), wizardStep.getPagexId(), WizardCommand.PREVIOUS);
    }

    @Override
    public void allowWizardCancel(WizardAO wizard, WizardStepAO wizardStep) {
        this.allowCommand(wizard.getId(), wizardStep.getPagexId(), WizardCommand.CANCEL);
    }

    @Override
    public void allowWizardFinish(WizardAO wizard, WizardStepAO wizardStep) {
        this.allowCommand(wizard.getId(), wizardStep.getPagexId(), WizardCommand.FINISH);
    }

    @Override
    public void allowWizardNavigateTo(WizardAO wizard, WizardStepAO wizardStep) {
        this.allowCommand(wizard.getId(), wizardStep.getPagexId(), WizardCommand.NAVIGATE_TO);
    }

    private void allowCommand(String wizardId, String wizardStepId, WizardCommand command) {
        Map<String, Set<WizardCommand>> allowedWizardCommands = this.getAllowedCommands();
        Set<WizardCommand> stepCommands = allowedWizardCommands.get(wizardId + "_" + wizardStepId);
        if (stepCommands == null) {
            stepCommands = new HashSet<WizardCommand>();
            allowedWizardCommands.put(wizardId + "_" + wizardStepId, stepCommands);
        }
        stepCommands.add(command);
    }

    private boolean isCommandAllowed(String wizardId, String wizardStepId, WizardCommand command) {
        Map<String, Set<WizardCommand>> allowedWizardCommands = this.getAllowedCommands();
        Set<WizardCommand> stepCommands = allowedWizardCommands.get(wizardId + "_" + wizardStepId);
        return stepCommands != null && stepCommands.contains((Object)command);
    }

    private void cleanAllowedCommands(String wizardId, String wizardStepId) {
        Map<String, Set<WizardCommand>> allowedWizardCommands = this.getAllowedCommands();
        if (allowedWizardCommands.isEmpty()) {
            return;
        }
        allowedWizardCommands.remove(wizardId + "_" + wizardStepId);
    }

    private Map<String, Set<WizardCommand>> getAllowedCommands() {
        Object cached = this.getAttributeFromSession(ALLOWED_WIZARD_STEP_COMMANDS_ATTRIBUTE);
        if (cached instanceof Map) {
            return (Map)cached;
        }
        ConcurrentHashMap<String, Set<WizardCommand>> allowedWizardCommands = new ConcurrentHashMap<String, Set<WizardCommand>>();
        this.setAttributeInSession(ALLOWED_WIZARD_STEP_COMMANDS_ATTRIBUTE, allowedWizardCommands);
        return allowedWizardCommands;
    }

    private boolean isFirstStep(WizardAO wizard, WizardStepAO wizardStep) throws WizardAPIException {
        if (wizard.getWizardSteps().isEmpty()) {
            LOG.warn(" isFirstStep(" + wizard + "," + wizardStep + ") - Steps are not properly configured");
            throw new WizardAPIException(" isFirstStep(" + wizard + "," + wizardStep + ")- Steps are not properly configured");
        }
        return wizard.getWizardSteps().get(0).equals(wizardStep);
    }

    private boolean isLastStep(WizardAO wizard, WizardStepAO wizardStep) throws WizardAPIException {
        if (wizard.getWizardSteps().isEmpty()) {
            LOG.warn(" isFirstStep(" + wizard + "," + wizardStep + ") - Steps are not properly configured");
            throw new WizardAPIException(" isFirstStep(" + wizard + "," + wizardStep + ")- Steps are not properly configured");
        }
        int lastStepIndex = wizard.getWizardSteps().size() - 1;
        return wizard.getWizardSteps().get(lastStepIndex).equals(wizardStep);
    }

    private WizardData getDataFromSession(String wizardId) {
        Object attribute = this.getAttributeFromSession(wizardId + WIZARD_ATTRIBUTE_SUFFIX);
        if (attribute instanceof WizardData) {
            return (WizardData)WizardData.class.cast(attribute);
        }
        return null;
    }

    private WizardData createWizardData(WizardAO wizard) {
        boolean firstStepIndex = false;
        WizardData data = new WizardData(wizard.getId());
        data.setCurrentStep(wizard.getWizardSteps().get(0));
        this.setAttributeInSession(wizard.getId() + WIZARD_ATTRIBUTE_SUFFIX, data);
        return data;
    }

    private WizardAO toWizardAO(WizardDef wizardDef) throws WizardAPIException {
        WizardAO result = new WizardAO(wizardDef.getId());
        result.setName(wizardDef.getName());
        result.setCancelRedirectUrl(wizardDef.getWizardCancelRedirectUrl());
        result.setFinishRedirectUrl(wizardDef.getWizardFinishRedirectUrl());
        result.setHandlerId(wizardDef.getHandler());
        result.setWizardSteps(this.toWizardSteps(wizardDef.getId(), wizardDef.getWizardSteps()));
        return result;
    }

    private List<WizardStepAO> toWizardSteps(String wizardId, List<String> wizardSteps) {
        ArrayList<WizardStepAO> resultSteps = new ArrayList<WizardStepAO>(wizardSteps.size());
        for (String pagexId : wizardSteps) {
            int position = wizardSteps.indexOf(pagexId);
            resultSteps.add(position, new WizardStepAO(wizardId, position, pagexId));
        }
        return resultSteps;
    }

    private void removeWizardData(String wizardId) {
        this.removeAttributeFromSession(wizardId + WIZARD_ATTRIBUTE_SUFFIX);
    }

    protected class WizardData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String wizardId;
        private WizardStepAO currentStep;
        private List<WizardStepAO> completedSteps = new ArrayList<WizardStepAO>();

        public WizardData(String aWizardId) {
            this.wizardId = aWizardId;
        }

        public String getWizardId() {
            return this.wizardId;
        }

        public WizardStepAO getCurrentStep() {
            return this.currentStep;
        }

        public void setCurrentStep(WizardStepAO currentStep) {
            this.currentStep = currentStep;
        }

        public List<WizardStepAO> getCompletedSteps() {
            return this.completedSteps;
        }

        public void addCompletedStep(WizardStepAO completed) {
            if (!this.completedSteps.contains(completed)) {
                this.completedSteps.add(completed);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("WizardData");
            sb.append("{completedSteps=").append(this.completedSteps.size());
            sb.append(", wizardId='").append(this.wizardId).append('\'');
            sb.append(", currentStep=").append(this.currentStep);
            sb.append('}');
            return sb.toString();
        }
    }
}

