/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.wizard.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.anoplass.api.APIFinder;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDef;
import net.anotheria.anosite.wizard.WizardCommand;
import net.anotheria.anosite.wizard.api.WizardAO;
import net.anotheria.anosite.wizard.api.WizardAPI;
import net.anotheria.anosite.wizard.api.WizardStepAO;
import net.anotheria.anosite.wizard.api.exception.WizardAPIException;
import net.anotheria.anosite.wizard.api.exception.WizardAPIFirstStepException;
import net.anotheria.anosite.wizard.api.exception.WizardAPILastStepException;
import net.anotheria.anosite.wizard.handler.WizardHandler;
import net.anotheria.anosite.wizard.handler.exceptions.WizardHandlerException;
import net.anotheria.anosite.wizard.handler.exceptions.WizardHandlerPreProcessException;
import net.anotheria.anosite.wizard.handler.exceptions.WizardHandlerProcessException;
import net.anotheria.anosite.wizard.handler.exceptions.WizardHandlerSubmitException;
import net.anotheria.anosite.wizard.handler.response.WizardHandlerResponse;
import net.anotheria.anosite.wizard.handler.response.WizardResponseCancel;
import net.anotheria.anosite.wizard.handler.response.WizardResponseChangeStep;
import net.anotheria.anosite.wizard.handler.response.WizardResponseContinue;
import net.anotheria.anosite.wizard.handler.response.WizardResponseFinish;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseWizardHandler
implements WizardHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private WizardAPI wizardAPI = (WizardAPI)APIFinder.findAPI(WizardAPI.class);

    protected BaseWizardHandler() {
    }

    @Override
    public WizardHandlerResponse preProcess(HttpServletRequest req, HttpServletResponse res, WizardDef wizard) throws WizardHandlerPreProcessException {
        this.addCacheControlHeadersToResponse(res);
        return WizardResponseContinue.INSTANCE;
    }

    @Override
    public WizardHandlerResponse process(HttpServletRequest req, HttpServletResponse res, WizardDef wizard) throws WizardHandlerProcessException {
        if (wizard.getWizardStepsSize() == 0) {
            throw new WizardHandlerProcessException(wizard.getId(), " wizard Steps are not configured!");
        }
        this.addCacheControlHeadersToResponse(res);
        try {
            WizardAO wizardAO = this.wizardAPI.getWizard(wizard.getId());
            WizardStepAO currentStep = this.wizardAPI.getCurrentStep(wizard.getId());
            return this.handleIncomingCommand(req, wizardAO, currentStep, false);
        }
        catch (WizardAPIException e) {
            this.log.error("WizardAPI failed", (Throwable)((Object)e));
            throw new WizardHandlerProcessException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (WizardHandlerException e) {
            this.log.error("process failed", (Throwable)e);
            throw new WizardHandlerProcessException(e.getMessage(), e);
        }
    }

    @Override
    public WizardHandlerResponse submit(HttpServletRequest req, HttpServletResponse res, WizardDef wizard) throws WizardHandlerSubmitException {
        try {
            WizardAO wizardAO = this.wizardAPI.getWizard(wizard.getId());
            WizardStepAO currentStep = this.wizardAPI.getCurrentStep(wizard.getId());
            return this.handleIncomingCommand(req, wizardAO, currentStep, true);
        }
        catch (WizardHandlerException e) {
            this.log.error("WizardAPI failed", (Throwable)e);
            throw new WizardHandlerSubmitException(e.getMessage(), e);
        }
        catch (WizardAPIException e) {
            this.log.error("submit failed", (Throwable)((Object)e));
            throw new WizardHandlerSubmitException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    protected boolean isNextStepAllowed(HttpServletRequest req, WizardAO wizard, WizardStepAO step, boolean isSubmit) {
        return req.getParameter("validationOnly") == null && isSubmit;
    }

    protected boolean isPreviousStepAllowed(HttpServletRequest req, WizardAO wizard, WizardStepAO step, boolean isSubmit) {
        return !isSubmit;
    }

    protected boolean isFinishAllowed(HttpServletRequest req, WizardAO wizard, WizardStepAO step, boolean isSubmit) {
        return req.getParameter("validationOnly") == null && isSubmit;
    }

    protected boolean isCancellationAllowed(HttpServletRequest req, WizardAO wizard, WizardStepAO step, boolean isSubmit) {
        return !isSubmit;
    }

    protected WizardHandlerResponse handleIncomingCommand(HttpServletRequest req, WizardAO wizard, WizardStepAO currentStep, boolean isSubmit) throws WizardHandlerException {
        WizardCommand command = WizardCommand.getCommandByValue(req.getParameterMap());
        switch (command) {
            case FINISH: {
                return this.processFinish(req, wizard, currentStep, isSubmit);
            }
            case CANCEL: {
                return this.processCancel(req, wizard, currentStep, isSubmit);
            }
            case PREVIOUS: {
                return this.processPreviousStep(req, wizard, currentStep, isSubmit);
            }
            case NEXT: {
                return this.processNextStep(req, wizard, currentStep, isSubmit);
            }
            case NAVIGATE_TO: {
                return this.processNavigateToStep(req, wizard, currentStep, isSubmit);
            }
        }
        this.getLogger().warn("Default Command - execution!");
        return this.processNextStep(req, wizard, currentStep, isSubmit);
    }

    private WizardHandlerResponse processFinish(HttpServletRequest req, WizardAO wizard, WizardStepAO currentStep, boolean isSubmit) throws WizardHandlerException {
        if (!this.isFinishAllowed(req, wizard, currentStep, isSubmit)) {
            this.log.debug("Wizard finish {" + wizard.getId() + "} not performed");
            return WizardResponseContinue.INSTANCE;
        }
        this.log.debug("Wizard finished {" + wizard.getId() + "}");
        try {
            if (this.wizardAPI.finishWizard(wizard)) {
                return new WizardResponseFinish(wizard.getFinishRedirectUrl());
            }
            this.log.debug("Wizard finish {" + wizard.getId() + "} not performed");
            return WizardResponseContinue.INSTANCE;
        }
        catch (WizardAPIException e) {
            this.log.error("WizardAPI failed", (Throwable)((Object)e));
            throw new WizardHandlerException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private WizardHandlerResponse processCancel(HttpServletRequest req, WizardAO wizard, WizardStepAO currentStep, boolean isSubmit) throws WizardHandlerException {
        if (!this.isCancellationAllowed(req, wizard, currentStep, isSubmit)) {
            this.log.debug("Wizard cancel {" + wizard.getId() + "} not performed");
            return WizardResponseContinue.INSTANCE;
        }
        try {
            if (this.wizardAPI.cancelWizard(wizard)) {
                return new WizardResponseCancel(wizard.getCancelRedirectUrl());
            }
            this.log.debug("Wizard cancel {" + wizard.getId() + "} not performed");
            return WizardResponseContinue.INSTANCE;
        }
        catch (WizardAPIException e) {
            this.log.error("WizardAPI failed", (Throwable)((Object)e));
            throw new WizardHandlerException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private WizardHandlerResponse processPreviousStep(HttpServletRequest req, WizardAO wizard, WizardStepAO currentStep, boolean isSubmit) throws WizardHandlerException {
        if (!this.isPreviousStepAllowed(req, wizard, currentStep, isSubmit)) {
            this.log.debug("Wizard previous step {" + wizard.getId() + "} not performed");
            return WizardResponseContinue.INSTANCE;
        }
        try {
            this.log.debug("Wizard previous step {" + wizard.getId() + "}");
            WizardStepAO changed = this.wizardAPI.adjustToPreviousStep(wizard.getId());
            if (changed.equals(currentStep)) {
                this.log.debug("Wizard previous step {" + wizard.getId() + "} not performed");
            }
            return WizardResponseChangeStep.INSTANCE;
        }
        catch (WizardAPIFirstStepException e) {
            return WizardResponseContinue.INSTANCE;
        }
        catch (WizardAPIException e) {
            this.log.error("WizardAPI failed", (Throwable)((Object)e));
            throw new WizardHandlerException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private WizardHandlerResponse processNavigateToStep(HttpServletRequest req, WizardAO wizard, WizardStepAO currentStep, boolean isSubmit) throws WizardHandlerException {
        if (isSubmit) {
            this.log.warn("Menu rendering is disabled. NAVIGATE_TO can't be executed.");
            return WizardResponseContinue.INSTANCE;
        }
        String stepIndex = req.getParameter(WizardCommand.NAVIGATE_TO.getCommandTitle());
        if (StringUtils.isEmpty((String)stepIndex)) {
            this.log.warn("Required parameter not found.");
            return WizardResponseContinue.INSTANCE;
        }
        int stepNumber = Integer.valueOf(stepIndex);
        if (stepNumber < 0 || stepNumber >= wizard.getWizardSteps().size()) {
            this.log.debug("Illegal step " + stepNumber);
            return WizardResponseContinue.INSTANCE;
        }
        try {
            WizardStepAO nextStep = this.wizardAPI.adjustToStep(wizard.getId(), stepNumber);
            if (nextStep.equals(currentStep)) {
                this.log.debug("step number is current");
            }
            return WizardResponseChangeStep.INSTANCE;
        }
        catch (WizardAPIException e) {
            this.log.error("WizardAPI failed", (Throwable)((Object)e));
            throw new WizardHandlerException("process navigateToStep failed  step:{" + stepIndex + "}", (Throwable)((Object)e));
        }
    }

    private WizardHandlerResponse processNextStep(HttpServletRequest req, WizardAO wizard, WizardStepAO currentStep, boolean isSubmit) throws WizardHandlerException {
        if (!this.isNextStepAllowed(req, wizard, currentStep, isSubmit)) {
            this.log.debug("Wizard next step {" + wizard.getId() + "} not performed");
            return WizardResponseContinue.INSTANCE;
        }
        try {
            WizardStepAO changed = this.wizardAPI.adjustToNextStep(wizard.getId());
            if (changed.equals(currentStep)) {
                this.log.debug("Wizard next step {" + wizard.getId() + "} not performed");
                return WizardResponseContinue.INSTANCE;
            }
            return WizardResponseChangeStep.INSTANCE;
        }
        catch (WizardAPILastStepException e) {
            try {
                if (this.wizardAPI.finishWizard(wizard)) {
                    return new WizardResponseFinish(wizard.getFinishRedirectUrl());
                }
                this.log.debug("Wizard finish  step {" + wizard.getId() + "} not performed");
                return WizardResponseContinue.INSTANCE;
            }
            catch (WizardAPIException e1) {
                this.log.error("WizardAPI failed", (Throwable)((Object)e));
                throw new WizardHandlerException(e1.getMessage(), (Throwable)((Object)e1));
            }
        }
        catch (WizardAPIException e) {
            this.log.error("WizardAPI failed", (Throwable)((Object)e));
            throw new WizardHandlerException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private void addCacheControlHeadersToResponse(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache, no-store, post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
    }

    protected Logger getLogger() {
        return this.log;
    }

    public WizardAPI getWizardAPI() {
        return this.wizardAPI;
    }
}

