/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.wizard.handler;

import java.util.HashMap;
import java.util.Map;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.aswizarddata.data.WizardHandlerDef;
import net.anotheria.anosite.gen.aswizarddata.service.IASWizardDataService;
import net.anotheria.anosite.wizard.handler.BaseWizardHandler;
import net.anotheria.anosite.wizard.handler.WizardHandler;
import net.anotheria.anosite.wizard.handler.WizardHandlerProducer;
import net.anotheria.anosite.wizard.handler.WizardHandlerWrapper;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public final class WizardHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardHandlerFactory.class);
    private static IASWizardDataService wizardService;
    private static final Map<String, WizardHandlerProducer> wHProducers;

    private WizardHandlerFactory() {
        throw new IllegalAccessError("Can't be instantiated!");
    }

    public static WizardHandler createHandler(String id) {
        try {
            if (!StringUtils.isEmpty((String)id)) {
                WizardHandlerDef wHandlerDef = wizardService.getWizardHandlerDef(id);
                WizardHandlerProducer wProducer = WizardHandlerFactory.getProducer(wHandlerDef.getClazz() + "-" + wHandlerDef.getId());
                return new WizardHandlerWrapper((WizardHandler)Class.forName(wHandlerDef.getClazz()).newInstance(), wProducer);
            }
            BaseWizardHandler wHandler = new BaseWizardHandler();
            WizardHandlerProducer wProducer = WizardHandlerFactory.getProducer("BaseWizardHandlerProducer-default");
            return new WizardHandlerWrapper(wHandler, wProducer);
        }
        catch (Exception e) {
            LOGGER.error("createWizardHandler(" + id + ")", (Throwable)e);
            throw new RuntimeException("WizardHandler instantiation failed - " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized WizardHandlerProducer getProducer(String producerId) {
        WizardHandlerProducer wProducer = wHProducers.get(producerId);
        if (wProducer == null) {
            Map<String, WizardHandlerProducer> map = wHProducers;
            synchronized (map) {
                wProducer = wHProducers.get(producerId);
                if (wProducer == null) {
                    wProducer = new WizardHandlerProducer(producerId);
                    wHProducers.put(producerId, wProducer);
                }
            }
        }
        return wProducer;
    }

    static {
        wHProducers = new HashMap<String, WizardHandlerProducer>();
        try {
            wizardService = (IASWizardDataService)MetaFactory.get(IASWizardDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "IASWizardDataService init failure", (Throwable)e);
        }
    }
}

