/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.wizard.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDef;
import net.anotheria.anosite.wizard.handler.WizardHandler;
import net.anotheria.anosite.wizard.handler.response.WizardHandlerResponse;
import net.anotheria.anosite.wizard.handler.response.WizardResponseAbort;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.predefined.ActionStats;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.stats.Interval;

public final class WizardHandlerProducer
implements IStatsProducer {
    private String producerId;
    private ActionStats preProcessStats;
    private ActionStats process;
    private ActionStats submit;
    private final List<IStats> myStats;

    public WizardHandlerProducer(String aProducerId) {
        this.producerId = aProducerId;
        this.preProcessStats = new ActionStats("preProcess", this.getMonitoringIntervals());
        this.process = new ActionStats("process", this.getMonitoringIntervals());
        this.submit = new ActionStats("submit", this.getMonitoringIntervals());
        this.myStats = new ArrayList<IStats>();
        this.myStats.add((IStats)this.preProcessStats);
        this.myStats.add((IStats)this.process);
        this.myStats.add((IStats)this.submit);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)this);
    }

    protected Interval[] getMonitoringIntervals() {
        return Constants.getDefaultIntervals();
    }

    public String getCategory() {
        return "wizard-handler";
    }

    public String getProducerId() {
        return this.producerId;
    }

    public List<IStats> getStats() {
        return this.myStats;
    }

    public String getSubsystem() {
        return "ano-site";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WizardHandlerResponse preProcess(HttpServletRequest req, HttpServletResponse res, WizardDef wizard, WizardHandler target) {
        CurrentlyTracedCall runningUseCase;
        this.preProcessStats.addRequest();
        long startTime = System.nanoTime();
        TracedCall aRunningUseCase = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentStep = null;
        CurrentlyTracedCall currentlyTracedCall = runningUseCase = aRunningUseCase.callTraced() ? (CurrentlyTracedCall)aRunningUseCase : null;
        if (runningUseCase != null) {
            currentStep = runningUseCase.startStep(this.getProducerId() + '.' + "preProcess", (IStatsProducer)this, "preProcess");
        }
        try {
            WizardHandlerResponse wizardHandlerResponse = target.preProcess(req, res, wizard);
            return wizardHandlerResponse;
        }
        catch (Exception e) {
            this.preProcessStats.notifyError();
            WizardResponseAbort wizardResponseAbort = new WizardResponseAbort(e);
            return wizardResponseAbort;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            this.preProcessStats.addExecutionTime(duration);
            this.preProcessStats.notifyRequestFinished();
            if (currentStep != null) {
                currentStep.setDuration(duration);
            }
            if (runningUseCase != null) {
                runningUseCase.endStep();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WizardHandlerResponse process(HttpServletRequest req, HttpServletResponse res, WizardDef wizard, WizardHandler target) {
        CurrentlyTracedCall runningUseCase;
        this.process.addRequest();
        long startTime = System.nanoTime();
        TracedCall aRunningUseCase = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentElement = null;
        CurrentlyTracedCall currentlyTracedCall = runningUseCase = aRunningUseCase.callTraced() ? (CurrentlyTracedCall)aRunningUseCase : null;
        if (runningUseCase != null) {
            currentElement = runningUseCase.startStep(this.getProducerId() + '.' + "process", (IStatsProducer)this, "process");
        }
        try {
            WizardHandlerResponse wizardHandlerResponse = target.process(req, res, wizard);
            return wizardHandlerResponse;
        }
        catch (Exception e) {
            this.process.notifyError();
            WizardResponseAbort wizardResponseAbort = new WizardResponseAbort(e);
            return wizardResponseAbort;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            this.process.addExecutionTime(duration);
            this.process.notifyRequestFinished();
            if (currentElement != null) {
                currentElement.setDuration(duration);
            }
            if (runningUseCase != null) {
                runningUseCase.endStep();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WizardHandlerResponse submit(HttpServletRequest req, HttpServletResponse res, WizardDef wizard, WizardHandler target) {
        CurrentlyTracedCall runningUseCase;
        this.submit.addRequest();
        long startTime = System.nanoTime();
        TracedCall aRunningUseCase = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentElement = null;
        CurrentlyTracedCall currentlyTracedCall = runningUseCase = aRunningUseCase.callTraced() ? (CurrentlyTracedCall)aRunningUseCase : null;
        if (runningUseCase != null) {
            currentElement = runningUseCase.startStep(this.getProducerId() + '.' + "submit", (IStatsProducer)this, "submit");
        }
        try {
            WizardHandlerResponse wizardHandlerResponse = target.submit(req, res, wizard);
            return wizardHandlerResponse;
        }
        catch (Exception e) {
            this.submit.notifyError();
            WizardResponseAbort wizardResponseAbort = new WizardResponseAbort(e);
            return wizardResponseAbort;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            this.submit.addExecutionTime(duration);
            this.submit.notifyRequestFinished();
            if (currentElement != null) {
                currentElement.setDuration(duration);
            }
            if (runningUseCase != null) {
                runningUseCase.endStep();
            }
        }
    }
}

