/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util;

import java.io.Serializable;
import java.util.GregorianCalendar;
import net.anotheria.util.NumberUtils;

public class Date
implements Serializable {
    private static final long serialVersionUID = -8683008562899070994L;
    public String wDay = null;
    public int day = -1;
    public int month = -1;
    public int year = -1;
    public int hour = -1;
    public int min = -1;
    public int sec = 0;
    private int dayOfWeek;
    public static final String[] MONTH = new String[]{null, "Jan", "Feb", "Mar", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final int[] DAY_OF_MONTH = new int[]{-1, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String[] DAY = new String[]{"Sun.", "Mon.", "Tue.", "Wed.", "Thu.", "Fri.", "Sat."};

    public Date(int aDay, int aMonth, int aYear) {
        this(aDay, aMonth, aYear, -1, -1);
    }

    public Date(int aDay, int aMonth, int aYear, int aHour, int aMin) {
        this.month = aMonth;
        this.day = aDay;
        this.year = aYear;
        this.hour = aHour;
        this.min = aMin;
        this.wDay = this.calcDay(aDay, aMonth, aYear);
    }

    public Date(long aMillis) {
        java.util.Date d = new java.util.Date(aMillis);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        cal.setTime(d);
        this.month = cal.get(2) + 1;
        this.day = cal.get(5);
        this.year = cal.get(1);
        this.hour = cal.get(11);
        this.min = cal.get(12);
        this.sec = cal.get(13);
        this.wDay = this.calcDay(this.day, this.month, this.year);
    }

    public static Date currentDate() {
        return new Date(System.currentTimeMillis());
    }

    private String calcDay(int aDay, int aMonth, int aYear) {
        GregorianCalendar cal = new GregorianCalendar(aYear, aMonth - 1, aDay);
        int dow = cal.get(7);
        this.dayOfWeek = dow - 1;
        return DAY[this.dayOfWeek];
    }

    public static boolean isValid(Date aD1) {
        if (aD1.month < 1 || aD1.month > 12) {
            return false;
        }
        if (aD1.day < 1) {
            return false;
        }
        GregorianCalendar cal = new GregorianCalendar();
        if (aD1.month == 2 && cal.isLeapYear(aD1.year) && aD1.day > 29) {
            return false;
        }
        if (aD1.month == 2 && !cal.isLeapYear(aD1.year) && aD1.day > 28) {
            return false;
        }
        if (aD1.month != 2 && aD1.day > DAY_OF_MONTH[aD1.month]) {
            return false;
        }
        if (aD1.hour < -1 || aD1.hour > 23) {
            return false;
        }
        if (aD1.min < -1 || aD1.min > 59) {
            return false;
        }
        String pWDay = aD1.calcDay(aD1.day, aD1.month, aD1.year);
        return pWDay.equals(aD1.wDay);
    }

    public boolean isValid() {
        return Date.isValid(this);
    }

    public String toString() {
        String ret = this.wDay;
        ret = ret + " " + NumberUtils.itoa(this.day, 2) + ".";
        ret = ret + NumberUtils.itoa(this.month, 2) + "." + this.year;
        if (this.min != -1) {
            ret = ret + ", ";
            ret = ret + NumberUtils.itoa(this.hour, 2) + ":";
            ret = ret + NumberUtils.itoa(this.min, 2);
        }
        return ret;
    }

    public static Date parse(String aDateStrg) {
        if (aDateStrg.indexOf(46) != -1 && aDateStrg.indexOf(58) == -1) {
            return Date.parseShort(aDateStrg, '.');
        }
        if (aDateStrg.indexOf(46) != -1 && aDateStrg.indexOf(58) != -1) {
            return Date.parseLong(aDateStrg, '.');
        }
        if (aDateStrg.indexOf(45) != -1 && aDateStrg.indexOf(58) == -1) {
            return Date.parseShort(aDateStrg, '-');
        }
        if (aDateStrg.indexOf(45) != -1 && aDateStrg.indexOf(58) != -1) {
            return Date.parseLong(aDateStrg, '-');
        }
        if (aDateStrg.indexOf(32) != -1 && aDateStrg.indexOf(58) == -1) {
            return Date.parseShort(aDateStrg, ' ');
        }
        if (aDateStrg.indexOf(32) != -1 && aDateStrg.indexOf(58) != -1) {
            return Date.parseLong(aDateStrg, ' ');
        }
        if (aDateStrg.indexOf(46) != -1 && aDateStrg.indexOf(58) == -1) {
            return Date.parseShort(aDateStrg, '.');
        }
        if (aDateStrg.indexOf(46) != -1 && aDateStrg.indexOf(58) != -1) {
            return Date.parseLong(aDateStrg, '.');
        }
        return null;
    }

    public static Date parseLong(String aDateStrg, char aCh) {
        int pFirst = aDateStrg.indexOf(aCh, 0);
        String dayStrg = aDateStrg.substring(0, pFirst);
        int pSecond = aDateStrg.indexOf(aCh, ++pFirst);
        String monthStrg = aDateStrg.substring(pFirst, pSecond);
        int yearB = pSecond + 1;
        int yearE = pSecond + 5;
        String yearStrg = aDateStrg.substring(yearB, yearE);
        int dbp = aDateStrg.indexOf(58);
        String hrStrg = aDateStrg.substring(pSecond += 6, dbp);
        String minStrg = aDateStrg.substring(dbp + 1, aDateStrg.length());
        try {
            int day = Integer.parseInt(dayStrg);
            int month = Integer.parseInt(monthStrg);
            int year = Integer.parseInt(yearStrg);
            int hour = Integer.parseInt(hrStrg);
            int min = Integer.parseInt(minStrg);
            Date ret = new Date(day, month, year, hour, min);
            return ret;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Date parseShort(String aDateStrg, char aCh) {
        int pSecond;
        int pFirst = aDateStrg.indexOf(aCh, 0);
        if (pFirst < 0) {
            throw new IllegalArgumentException("Date string wrong format: " + aDateStrg + ". Expected: dd" + aCh + "mm" + aCh + "yyyy");
        }
        String dayStrg = aDateStrg.substring(0, pFirst);
        if ((pSecond = aDateStrg.indexOf(aCh, ++pFirst)) < 0) {
            throw new IllegalArgumentException("Date string wrong format: " + aDateStrg + ". Expected: dd" + aCh + "mm" + aCh + "yyyy");
        }
        String monthStrg = aDateStrg.substring(pFirst, pSecond);
        String yearStrg = aDateStrg.substring(++pSecond, aDateStrg.length());
        try {
            int day = Integer.parseInt(dayStrg);
            int month = Integer.parseInt(monthStrg);
            int year = Integer.parseInt(yearStrg);
            Date ret = new Date(day, month, year);
            return ret;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Date string wrong format: " + aDateStrg + ". Expected: dd" + aCh + "mm" + aCh + "yyyy");
        }
    }

    public long toMill() {
        GregorianCalendar cal = this.hour != -1 ? new GregorianCalendar(this.year, this.month - 1, this.day, this.hour, this.min) : new GregorianCalendar(this.year, this.month - 1, this.day, 0, 0);
        java.util.Date d = cal.getTime();
        return d.getTime();
    }

    public boolean equals(Object o) {
        return o instanceof Date ? ((Date)o).toMill() == this.toMill() : false;
    }

    public int getDay() {
        return this.day;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMin() {
        return this.min;
    }

    public int getMonth() {
        return this.month;
    }

    public String getW_day() {
        return this.wDay;
    }

    public int getYear() {
        return this.year;
    }

    public String toISO8601Timestamp() {
        return NumberUtils.makeISO8601TimestampString(this.toMill());
    }

    public String toISO8601Date() {
        return NumberUtils.makeISO8601DateString(this.toMill());
    }
}

