/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import net.anotheria.util.io.UnicodeReader;

public final class IOUtils {
    public static byte[] readFileAtOnce(File file) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        return IOUtils.readFileAtOnce(fIn);
    }

    public static byte[] readFileAtOnce(String filename) throws IOException {
        FileInputStream fIn = new FileInputStream(filename);
        return IOUtils.readFileAtOnce(fIn);
    }

    private static byte[] readFileAtOnce(FileInputStream fIn) throws IOException {
        byte[] ret = new byte[fIn.available()];
        fIn.read(ret);
        fIn.close();
        return ret;
    }

    public static String readFileAtOnceAsString(String filename) throws IOException {
        return new String(IOUtils.readFileAtOnce(filename));
    }

    public static String readFileAtOnceAsString(File file) throws IOException {
        return new String(IOUtils.readFileAtOnce(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileBufferedAsString(String filename) throws IOException {
        String string;
        FileReader in = null;
        try {
            StringBuilder result = new StringBuilder();
            char[] buffer = new char[2048];
            in = new FileReader(filename);
            int len = 0;
            do {
                if ((len = in.read(buffer)) <= 0) continue;
                result.append(buffer, 0, len);
            } while (len > 0);
            string = result.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeIgnoringException(in);
            throw throwable;
        }
        IOUtils.closeIgnoringException(in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readInputStreamBufferedAsString(InputStream in, String charset) throws IOException {
        String string;
        BufferedReader reader = null;
        try {
            int read;
            reader = new BufferedReader(new UnicodeReader(in, charset));
            StringBuffer result = new StringBuffer();
            char[] cbuf = new char[2048];
            while ((read = reader.read(cbuf)) > 0) {
                result.append(cbuf, 0, read);
            }
            string = result.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeIgnoringException(reader);
            throw throwable;
        }
        IOUtils.closeIgnoringException(reader);
        return string;
    }

    public static String readFileBufferedAsString(File file, String charset) throws IOException {
        return IOUtils.readInputStreamBufferedAsString(new FileInputStream(file), charset);
    }

    public static String readlineFromStdIn() throws IOException {
        int c;
        StringBuilder ret = new StringBuilder();
        while ((c = System.in.read()) != 10 && c != -1) {
            if (c == 13) continue;
            ret.append((char)c);
        }
        return ret.toString();
    }

    public static void closeIgnoringException(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeIgnoringException(buffer);
        }
    }
}

