/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.anotheria.util.Date;
import net.anotheria.util.StringUtils;

public final class NumberUtils {
    public static final String[] MONTH = new String[]{"", "JAN", "FEB", "MAR", "APR", "MAI", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};

    public static String itoa(int i, int limit) {
        String a = "" + i;
        while (a.length() < limit) {
            a = "0" + a;
        }
        return a;
    }

    public static String itoa(int i) {
        return NumberUtils.itoa(i, 2);
    }

    public static String makeDateStringLong(long time) {
        Date date = new Date(time);
        return NumberUtils.itoa(date.day) + " " + MONTH[date.month] + " " + date.year;
    }

    public static String makeDateString(long time) {
        Date date = new Date(time);
        int minus = date.year > 2000 ? 2000 : 1900;
        return NumberUtils.itoa(date.day) + " " + MONTH[date.month] + " " + NumberUtils.itoa(date.year - minus);
    }

    public static String makeDigitalDateString(long time) {
        Date date = new Date(time);
        return NumberUtils.itoa(date.day) + "." + NumberUtils.itoa(date.month) + "." + NumberUtils.itoa(date.year);
    }

    public static String makeDigitalDateStringLong(long time) {
        Date date = new Date(time);
        return NumberUtils.itoa(date.day) + "." + NumberUtils.itoa(date.month) + "." + NumberUtils.itoa(date.year, 4);
    }

    public static String makeTimeString(long time) {
        Date date = new Date(time);
        return NumberUtils.itoa(date.hour) + ":" + NumberUtils.itoa(date.min);
    }

    public static String makeTimeString12H(long time) {
        Date date = new Date(time);
        int hour = date.hour;
        String t = "am";
        if (hour > 12) {
            hour -= 12;
            t = "pm";
        }
        return NumberUtils.itoa(hour) + ":" + NumberUtils.itoa(date.min) + " " + t;
    }

    public static String makeSizeString(long size) {
        String bytes = "B";
        if (size > 1024L) {
            size /= 1024L;
            bytes = "kB";
        }
        if (size > 1024L) {
            size /= 1024L;
            bytes = "Mb";
        }
        if (size > 1024L) {
            size /= 1024L;
            bytes = "Gb";
        }
        return "" + size + " " + bytes;
    }

    public static String getDateString(int day, int month, int year) {
        return NumberUtils.itoa(day, 2) + "." + NumberUtils.itoa(month, 2) + "." + NumberUtils.itoa(year, 2);
    }

    public static String makeISO8601DateString(long millis) {
        Date d = new Date(millis);
        return NumberUtils.itoa(d.year, 4) + "-" + NumberUtils.itoa(d.month) + "-" + NumberUtils.itoa(d.day);
    }

    public static String makeISO8601DateString() {
        return NumberUtils.makeISO8601DateString(System.currentTimeMillis());
    }

    public static String makeISO8601TimestampString() {
        return NumberUtils.makeISO8601TimestampString(System.currentTimeMillis());
    }

    public static String makeISO8601TimestampString(long millis) {
        String ret = NumberUtils.makeISO8601DateString(millis);
        Date d = new Date(millis);
        ret = ret + "T" + NumberUtils.itoa(d.hour) + ":" + NumberUtils.itoa(d.min) + ":" + NumberUtils.itoa(d.sec);
        ret = ret + "," + NumberUtils.itoa((int)(millis - millis / 1000L * 1000L), 3);
        return ret;
    }

    public static long parseDateString(String str) {
        if (str.length() == 0) {
            return 0L;
        }
        String[] t = StringUtils.tokenize(str, '.');
        int d = Integer.parseInt(t[0]);
        int m = Integer.parseInt(t[1]);
        int y = Integer.parseInt(t[2]);
        if (y < 100) {
            y = y < 20 ? (y += 2000) : (y += 1900);
        }
        return new Date(d, m, y).toMill();
    }

    public static String getCurrencyValue(float aValue) {
        return NumberUtils.getCurrencyValue((double)aValue);
    }

    public static String getCurrencyValue(double aValue) {
        int tmp = (int)((aValue += 0.005) * 100.0);
        aValue = (double)tmp / 100.0;
        String ret = "" + aValue;
        int ind = ret.indexOf(46);
        if (ind == -1) {
            return ret + ".00";
        }
        if (ret.length() - ind - 1 < 2) {
            ret = ret + "0";
        }
        return ret;
    }

    public static boolean luhnCheckNumber(String aNumber) {
        int sum = 0;
        int l = aNumber.length() - 1;
        boolean doDouble = false;
        for (int i = 0; i < aNumber.length(); ++i) {
            int n = aNumber.charAt(l - i) - 48;
            if (n < 0 || n > 10) {
                throw new IllegalArgumentException("Not a digit: " + aNumber.charAt(l - i) + " in " + aNumber + " at " + (l - i));
            }
            if (doDouble) {
                int tmp = n * 2;
                sum += tmp % 10;
                sum += tmp / 10;
            } else {
                sum += n;
            }
            doDouble = !doDouble;
        }
        return sum % 10 == 0;
    }

    public static String getDotedNumber(long number) {
        return NumberUtils.getDotedNumber(number, '.');
    }

    public static String getDotedNumber(long number, char separatorChar) {
        if (number < 0L) {
            return "-" + NumberUtils.getDotedNumber(-1L * number, separatorChar);
        }
        String n = StringUtils.reverseString("" + number);
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < n.length(); ++i) {
            ret.insert(0, n.charAt(i));
            if (i >= n.length() - 1 || (i + 1) % 3 != 0) continue;
            ret.insert(0, separatorChar);
        }
        return ret.toString();
    }

    public static String getDotedNumber(long number, Locale locale) {
        if (locale.getLanguage() == null) {
            return NumberUtils.getDotedNumber(number);
        }
        if (locale.getLanguage().equals(Locale.GERMAN.getLanguage())) {
            return NumberUtils.getDotedNumberDE(number);
        }
        return NumberUtils.getDotedNumberUS(number);
    }

    public static String getDotedNumberUS(long number) {
        return NumberUtils.getDotedNumber(number, ',');
    }

    public static String getDotedNumberDE(long number) {
        return NumberUtils.getDotedNumber(number, '.');
    }

    public static double fractionRound(double value, int fraction) {
        int shift = (int)Math.pow(10.0, fraction);
        return 1.0 * (double)Math.round(value * (double)shift) / (double)shift;
    }

    public static String format(double value, int integral, int fraction, char delimiter) {
        String integralPattern = "#0";
        if (integral > 0) {
            integralPattern = "0";
            for (int i = 1; i < integral; ++i) {
                integralPattern = integralPattern + '0';
            }
        }
        String fractionPattern = "########################";
        if (fraction > 0) {
            fractionPattern = "0";
            for (int i = 1; i < fraction; ++i) {
                fractionPattern = fractionPattern + '0';
            }
        }
        DecimalFormatSymbols delimiterFormat = new DecimalFormatSymbols();
        delimiterFormat.setDecimalSeparator(delimiter);
        return new DecimalFormat(integralPattern + "." + fractionPattern, delimiterFormat).format(value);
    }

    public static String currencyFormat(double value, char delimiter) {
        return NumberUtils.format(value, -1, 2, delimiter);
    }

    private NumberUtils() {
    }

    public static void main(String[] a) {
        System.out.println(NumberUtils.makeISO8601TimestampString());
    }
}

