/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.anotheria.util.ArrayUtils;

public final class StringUtils {
    public static Vector<String> tokenize2vector(String source, char delimiter) {
        Vector<String> v = new Vector<String>();
        StringBuilder currentS = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == delimiter) {
                if (currentS.length() > 0) {
                    v.addElement(currentS.toString());
                } else {
                    v.addElement(new String(""));
                }
                currentS = new StringBuilder();
                continue;
            }
            currentS.append(c);
        }
        if (currentS != null && currentS.length() > 0) {
            v.addElement(currentS.toString());
        }
        return v;
    }

    public static List<String> tokenize2list(String source, char delimiter, char escapeChar) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder currentS = new StringBuilder();
        boolean skipNext = false;
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (skipNext) {
                if (c != delimiter) {
                    currentS.append(escapeChar);
                }
                currentS.append(c);
                skipNext = false;
                continue;
            }
            if (c == escapeChar) {
                skipNext = true;
                continue;
            }
            if (c == delimiter) {
                if (currentS.length() > 0) {
                    ret.add(currentS.toString());
                } else {
                    ret.add(new String(""));
                }
                currentS = new StringBuilder();
            } else {
                currentS.append(c);
            }
            skipNext = false;
        }
        if (currentS.length() > 0) {
            ret.add(currentS.toString());
        }
        return ret;
    }

    public static List<String> tokenize2list(String source, char delimiter) {
        return Arrays.asList(StringUtils.tokenize(source, delimiter));
    }

    public static final Map<String, String> tokenize2map(String source, char entriesDelimiter, char keyValueDelimiter) {
        String[] entryStrArray;
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String entryStr : entryStrArray = StringUtils.tokenize(source, true, entriesDelimiter)) {
            String[] entry = StringUtils.tokenize(entryStr = entryStr.trim(), true, '=');
            if (entry.length != 2) {
                throw new IllegalArgumentException("Source [" + source + "] is not the valid string map with entries delimiter[" + entriesDelimiter + "] " + "and key->value delimiter [" + keyValueDelimiter + "]!  Wrong entry: " + entryStr);
            }
            ret.put(entry[0].trim(), entry[1].trim());
        }
        return ret;
    }

    public static final String[] tokenize(String source, char delimiter) {
        Vector<String> v = StringUtils.tokenize2vector(source, delimiter);
        String[] ret = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            ret[i] = v.elementAt(i);
        }
        return ret;
    }

    public static final String[] tokenize(String source, boolean ignoreEmptyTokens, char delimiter) {
        AbstractList v = new ArrayList();
        v = new Vector();
        StringBuilder currentS = new StringBuilder();
        for (char c : source.toCharArray()) {
            if (c == delimiter) {
                if (currentS.length() > 0 || !ignoreEmptyTokens) {
                    v.add(currentS.toString());
                }
                currentS = new StringBuilder();
                continue;
            }
            currentS.append(c);
        }
        if (currentS.length() > 0 || !ignoreEmptyTokens) {
            v.add(currentS.toString());
        }
        return v.toArray(new String[1]);
    }

    public static String[] tokenize(String source, char delimiter, char escapeChar) {
        return StringUtils.tokenize2list(source, delimiter, escapeChar).toArray(new String[0]);
    }

    public static String removeCharAt(String src, int position) {
        return new StringBuilder(src).deleteCharAt(position).toString();
    }

    public static String removeChar(String src, char c) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            if (src.charAt(i) == c) continue;
            ret.append(src.charAt(i));
        }
        return ret.toString();
    }

    public static String removeChars(String src, char[] c) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            char aC = src.charAt(i);
            boolean append = true;
            for (int t = 0; t < c.length; ++t) {
                if (aC != c[t]) continue;
                append = false;
                break;
            }
            if (!append) continue;
            ret.append(aC);
        }
        return ret.toString();
    }

    public static String removeLines(String src) {
        return StringUtils.replace(StringUtils.removeChar(src, '\r'), '\n', ' ');
    }

    public static String getFirstLine(String source) {
        StringBuilder line = new StringBuilder();
        int i = 0;
        while (i < source.length()) {
            line.append(source.charAt(i));
            if (source.charAt(i++) != '\n') continue;
            break;
        }
        return line.toString();
    }

    public static Map<String, String> buildHashTable(String source) {
        return Collections.synchronizedMap(StringUtils.buildParameterMap(source, '\n', ':'));
    }

    public static Map<String, String> buildParameterMap(String source) {
        return StringUtils.buildParameterMap(source, '\n', '=');
    }

    public static Map<String, String> buildParameterMap(String source, char lineDelimiter, char parameterDelimiter) {
        source = StringUtils.removeChar(source, '\r');
        String[] lines = StringUtils.tokenize(source, lineDelimiter);
        HashMap<String, String> ret = new HashMap<String, String>(lines.length);
        for (int i = 0; i < lines.length; ++i) {
            StringPair sp = StringUtils.splitString(lines[i], parameterDelimiter);
            if (sp.first == null || sp.second == null) continue;
            ret.put(sp.first.trim(), sp.second.trim());
        }
        return ret;
    }

    public static int charCount(String source, char toCount) {
        int sum = 0;
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) != toCount) continue;
            ++sum;
        }
        return sum;
    }

    public static String insert(String source, String insertion, int position) {
        return new StringBuilder(source).insert(position, insertion).toString();
    }

    public static String _replace2(String source, char replaceChar, char replaceWith) {
        String dest = new String("");
        int i = 0;
        while (i < source.length()) {
            dest = dest + (source.charAt(i++) == replaceChar ? replaceWith : source.charAt(i - 1));
        }
        return dest;
    }

    public static String replace(String source, char replaceChar, char replaceWith) {
        StringBuffer dest = new StringBuffer(source.length());
        int i = 0;
        while (i < source.length()) {
            dest.append(source.charAt(i++) == replaceChar ? replaceWith : source.charAt(i - 1));
        }
        return dest.toString();
    }

    public static String replace(String source, char replaceChar, String replaceWith) {
        String dest = new String("");
        int i = 0;
        while (i < source.length()) {
            dest = dest + (source.charAt(i++) == replaceChar ? replaceWith : "" + source.charAt(i - 1));
        }
        return dest;
    }

    public static String replace(String source, Map<String, String> map) {
        String dest = new String("");
        int i = 0;
        while (i < source.length()) {
            String replaceWith = map.get("" + source.charAt(i++));
            if (replaceWith != null) {
                dest = dest + replaceWith;
                continue;
            }
            dest = dest + "" + source.charAt(i - 1);
        }
        return dest;
    }

    public static StringPair splitString(String source, char delimiter) {
        int pDelPos = source.indexOf(delimiter);
        if (pDelPos == -1) {
            return new StringPair();
        }
        return new StringPair(source.substring(0, pDelPos), source.substring(pDelPos + 1, source.length()));
    }

    public static <T> Vector<T> reverse(Vector<T> v) {
        Vector<T> ret = new Vector<T>(v.size());
        for (int i = v.size() - 1; i >= 0; --i) {
            ret.addElement(v.elementAt(i));
        }
        return ret;
    }

    public static String concat(String a, String b) {
        return StringUtils.concat(a, b, " ");
    }

    public static String concat(String a, String b, String delimiter) {
        return a == null || a.length() == 0 ? b : (b == null || b.length() == 0 ? a : a + delimiter + b);
    }

    public static String combineStrings(String[] strings, char delimiter) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            ret.append(strings[i]);
            if (i >= strings.length - 1) continue;
            ret.append(delimiter);
        }
        return ret.toString();
    }

    public static String capitalize(String s) {
        char c = s.charAt(0);
        return Character.toUpperCase(c) + s.substring(1);
    }

    public static String getStringAfter(String src, String toSearch, int start) {
        int ind = src.indexOf(toSearch, start);
        if (ind == -1) {
            return "";
        }
        return src.substring(ind + toSearch.length());
    }

    public static String getStringAfter(String src, String toSearch) {
        return StringUtils.getStringAfter(src, toSearch, 0);
    }

    public static String getStringAfterIncl(String src, String toSearch, int start) {
        int ind = src.indexOf(toSearch, start);
        if (ind == -1) {
            return "";
        }
        return src.substring(ind);
    }

    public static String getStringAfterIncl(String src, String toSearch) {
        return StringUtils.getStringAfterIncl(src, toSearch, 0);
    }

    public static String getStringWith(String src, String toSearch, int start) {
        int ind = src.indexOf(toSearch, start);
        if (ind == -1) {
            return "";
        }
        return src.substring(ind);
    }

    public static String getStringWith(String src, String toSearch) {
        return StringUtils.getStringWith(src, toSearch, 0);
    }

    public static String getStringBefore(String src, String toSearch, int start) {
        int ind = src.indexOf(toSearch, start);
        if (ind == -1) {
            return "";
        }
        return src.substring(start, ind);
    }

    public static String getStringBefore(String src, String toSearch) {
        return StringUtils.getStringBefore(src, toSearch, 0);
    }

    public static String getStringBeforeIncl(String src, String toSearch, int start) {
        int ind = src.indexOf(toSearch, start);
        if (ind == -1) {
            return "";
        }
        return src.substring(start, ind + toSearch.length());
    }

    public static String getStringBeforeIncl(String src, String toSearch) {
        return StringUtils.getStringBeforeIncl(src, toSearch, 0);
    }

    public static String removeImgTag(String s) {
        return StringUtils.removeTag(s, "img");
    }

    public static String removeAnchorTag(String s) {
        return StringUtils.removeTag(s, "a");
    }

    public static String removeAnchorEndTag(String s) {
        return StringUtils.removeTag(s, "/a");
    }

    public static String removeTag(String s, String tag) {
        int index;
        tag = "<" + tag;
        while ((index = s.indexOf(tag)) != -1) {
            String r = StringUtils.getStringBefore(s, tag);
            s = r = r + StringUtils.getStringAfter(s, ">", index);
        }
        return s;
    }

    public static String removeString(String s, String toRemove) {
        int index;
        while ((index = s.indexOf(toRemove)) != -1) {
            String r = StringUtils.getStringBefore(s, toRemove);
            s = r = r + StringUtils.getStringAfter(s, toRemove, index);
        }
        return s;
    }

    public static String remove(String source, int beginIndex, int length) {
        return new StringBuilder(source).delete(beginIndex, beginIndex + length).toString();
    }

    public static String replaceOnce(String src, String toReplace, String with) {
        int index = src.indexOf(toReplace);
        if (index == -1) {
            return src;
        }
        String s = src.substring(0, index);
        s = s + with;
        src = s = s + src.substring(index + toReplace.length(), src.length());
        return src;
    }

    public static String replace(String src, String toReplace, String with) {
        int index = 0;
        while ((index = src.indexOf(toReplace)) > -1) {
            String s = src.substring(0, index);
            s = s + with;
            src = s = s + src.substring(index + toReplace.length(), src.length());
        }
        return src;
    }

    public static String replace(String src, String toReplace, char with) {
        int index = 0;
        while ((index = src.indexOf(toReplace)) > -1) {
            StringBuffer s = new StringBuffer(src.substring(0, index));
            s.append(with);
            s.append(src.substring(index + toReplace.length(), src.length()));
            src = s.toString();
        }
        return src;
    }

    public static String removeCComments(String src) {
        StringBuilder ret = new StringBuilder();
        boolean inComments = false;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (inComments) {
                if (c != '*' || src.charAt(i + 1) != '/') continue;
                inComments = false;
                ++i;
                continue;
            }
            if (c == '/') {
                if (src.charAt(i + 1) == '*') {
                    inComments = true;
                    ++i;
                    continue;
                }
                ret.append(c);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String removeCPPComments(String src) {
        StringBuilder ret = new StringBuilder();
        boolean inComments = false;
        boolean inQuotes = false;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (inComments) {
                if (c != '\n') continue;
                inComments = false;
                inQuotes = false;
                continue;
            }
            if (c == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (!inQuotes && c == '/') {
                if (src.charAt(i + 1) == '/') {
                    inComments = true;
                    ++i;
                    continue;
                }
                ret.append(c);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String removeBashComments(String src) {
        StringBuilder ret = new StringBuilder();
        boolean inComments = false;
        boolean inQuotes = false;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (inComments) {
                if (c != '\n') continue;
                inComments = false;
                inQuotes = false;
                continue;
            }
            if (c == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (!inQuotes && c == '#') {
                inComments = true;
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String reverseString(String src) {
        String ret = "";
        for (int i = src.length() - 1; i >= 0; --i) {
            ret = ret + src.charAt(i);
        }
        return ret;
    }

    public static String makeDelimitedString(String src, String delimiter, int interval) {
        String ret = "";
        int t = 0;
        for (int i = src.length() - 1; i >= 0; --i) {
            ret = ret + src.charAt(i);
            if (++t % interval != 0 || i == 0) continue;
            ret = ret + delimiter;
        }
        return StringUtils.reverseString(ret);
    }

    public static String prefill(String s, int desiredLength, String fillString) {
        while (s.length() < desiredLength) {
            s = fillString + s;
        }
        return s;
    }

    public static String postfill(String s, int desiredLength, String fillString) {
        while (s.length() < desiredLength) {
            s = s + fillString;
        }
        return s;
    }

    public static List<String> extractTags(String source, char tagStart, char tagEnd) {
        ArrayList<String> ret = new ArrayList<String>();
        String currentTag = null;
        boolean inTag = false;
        int l = source.length();
        for (int i = 0; i < l; ++i) {
            char c = source.charAt(i);
            if (!inTag) {
                if (c != tagStart) continue;
                currentTag = "" + c;
                inTag = true;
                continue;
            }
            currentTag = currentTag + c;
            if (c != tagEnd) continue;
            inTag = false;
            ret.add(currentTag);
            currentTag = null;
        }
        return ret;
    }

    public static List<String> extractTagsWithEscapeChar(String source, char tagStart, char tagEnd, char escapeChar) {
        ArrayList<String> ret = new ArrayList<String>();
        String currentTag = null;
        boolean inTag = false;
        boolean skipNext = false;
        boolean skipNow = false;
        int l = source.length();
        for (int i = 0; i < l; ++i) {
            char c = source.charAt(i);
            skipNow = skipNext;
            skipNext = false;
            if (c == escapeChar) {
                skipNext = true;
                continue;
            }
            if (!inTag) {
                if (c != tagStart || skipNow) continue;
                currentTag = "" + c;
                inTag = true;
                continue;
            }
            currentTag = currentTag + c;
            if (c != tagEnd || skipNow) continue;
            inTag = false;
            ret.add(currentTag);
            currentTag = null;
        }
        return ret;
    }

    public static String strip(String src, int fromBeginn, int fromEnd) {
        return src.substring(fromBeginn, src.length() - fromEnd);
    }

    public static boolean isSurroundedWith(String src, char starting, char ending) {
        return src.length() > 0 && src.charAt(0) == starting && src.charAt(src.length() - 1) == ending;
    }

    public static String removeSurround(String src) {
        return StringUtils.strip(src, 1, 1);
    }

    public static String surroundWith(String src, char starting, char ending) {
        StringBuilder ret = new StringBuilder();
        ret.append(starting);
        ret.append(src);
        ret.append(ending);
        return ret.toString();
    }

    public static List<String> extractSuperTags(String source, char tagStart, char tagEnd, char escapeChar) {
        List<String> index = StringUtils.indexSuperTags(source, tagStart, tagEnd);
        ArrayList<String> ret = new ArrayList<String>();
        for (String tag : index) {
            if (tag.charAt(0) != tagStart) continue;
            ret.add(tag);
        }
        return ret;
    }

    public static List<String> indexSuperTags(String source, char tagStart, char tagEnd) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder currentTag = new StringBuilder();
        int inTag = 0;
        int l = source.length();
        for (int i = 0; i < l; ++i) {
            char c = source.charAt(i);
            if (c == tagStart && ++inTag == 1) {
                if (currentTag.length() > 0) {
                    ret.add(currentTag.toString());
                }
                currentTag = new StringBuilder();
            }
            currentTag.append(c);
            if (c != tagEnd) continue;
            if (inTag == 1) {
                ret.add(currentTag.toString());
                currentTag = new StringBuilder();
                inTag = 0;
                continue;
            }
            if (inTag <= 0) continue;
            --inTag;
        }
        if (currentTag.length() > 0) {
            ret.add(currentTag.toString());
        }
        return ret;
    }

    public static final List<String> tokenize(String source, char escapeStart, char escapeEnd, char ... delimiters) {
        HashSet<Character> delimitersHash = new HashSet<Character>(delimiters.length);
        for (char del : delimiters) {
            delimitersHash.add(Character.valueOf(del));
        }
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder currentTag = new StringBuilder();
        int inEscape = 0;
        int l = source.length();
        for (int i = 0; i < l; ++i) {
            char c = source.charAt(i);
            if (c == escapeStart) {
                ++inEscape;
            }
            if (inEscape < 1 && delimitersHash.contains(Character.valueOf(c)) && currentTag.length() > 0) {
                ret.add(currentTag.toString());
                currentTag = new StringBuilder();
                continue;
            }
            currentTag.append(c);
            if (c != escapeEnd || inEscape <= 0) continue;
            --inEscape;
        }
        if (currentTag.length() > 0) {
            ret.add(currentTag.toString());
        }
        return ret;
    }

    public static List<String> _tokenize(String source, char escapeStart, char escapeEnd, char ... delimiters) {
        return StringUtils._tokenize(source, escapeStart, escapeEnd, true, delimiters);
    }

    public static List<String> _tokenize(String source, char escapeStart, char escapeEnd, boolean skipEmptyTokens, char ... delimiters) {
        boolean quotingMode = escapeStart == escapeEnd;
        HashSet<Character> delimitersHash = new HashSet<Character>(delimiters.length);
        for (char del : delimiters) {
            delimitersHash.add(Character.valueOf(del));
        }
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder currentTag = new StringBuilder();
        int inEscape = 0;
        int l = source.length();
        for (int i = 0; i < l; ++i) {
            char c = source.charAt(i);
            if (c == escapeStart) {
                ++inEscape;
            }
            if (inEscape < 1 && delimitersHash.contains(Character.valueOf(c))) {
                if (!skipEmptyTokens || currentTag.length() > 0) {
                    ret.add(currentTag.toString());
                }
                currentTag.setLength(0);
                continue;
            }
            currentTag.append(c);
            if (c != escapeEnd) continue;
            if (quotingMode && inEscape == 2) {
                inEscape = 0;
            }
            if (quotingMode || inEscape <= 0) continue;
            --inEscape;
        }
        if (currentTag.length() > 0) {
            ret.add(currentTag.toString());
        }
        return ret;
    }

    public static String substringFromEnd(String src, int indexFromEnd) {
        if (src.length() <= indexFromEnd) {
            return "";
        }
        int end = src.length() - indexFromEnd;
        return src.substring(0, end);
    }

    public static <T> String concatenateTokens(Collection<T> tokens, char delimiter, char tokenStartingTag, char tokenEndingTag) {
        StringBuilder ret = new StringBuilder();
        boolean begin = true;
        for (T pT : tokens) {
            String t;
            String string = t = pT instanceof String ? (String)pT : "" + pT;
            if ((t = t.trim()).length() == 0) continue;
            if (!begin) {
                ret.append(delimiter);
            }
            ret.append(StringUtils.surroundWith(t, tokenStartingTag, tokenEndingTag));
            begin = false;
        }
        return ret.toString();
    }

    public static <T> String concatenateTokens(Collection<T> tokens, String delimiterSequence) {
        StringBuilder ret = new StringBuilder();
        boolean begin = true;
        for (T pT : tokens) {
            String t;
            String string = t = pT instanceof String ? (String)pT : "" + pT;
            if ((t = t.trim()).length() == 0) continue;
            if (!begin) {
                ret.append(delimiterSequence);
            }
            ret.append(t);
            begin = false;
        }
        return ret.toString();
    }

    public static <T> String concatenateTokens(String delimiterSequence, T ... tokens) {
        return StringUtils.concatenateTokens(ArrayUtils.asList(tokens), delimiterSequence);
    }

    public static String concatenateTokens(String delimiterSequence, int[] tokens) {
        return StringUtils.concatenateTokens(ArrayUtils.asList(tokens), delimiterSequence);
    }

    public static String concatenateTokens(String delimiterSequence, long[] tokens) {
        return StringUtils.concatenateTokens(ArrayUtils.asList(tokens), delimiterSequence);
    }

    public static <T> String concatenateTokens(String delimiterSequence, float[] tokens) {
        return StringUtils.concatenateTokens(ArrayUtils.asList(tokens), delimiterSequence);
    }

    public static String replaceUmlauts(String src) {
        StringBuilder ret = new StringBuilder();
        block9: for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            switch (c) {
                case '\u00e4': {
                    ret.append("ae");
                    continue block9;
                }
                case '\u00f6': {
                    ret.append("oe");
                    continue block9;
                }
                case '\u00fc': {
                    ret.append("ue");
                    continue block9;
                }
                case '\u00c4': {
                    ret.append("Ae");
                    continue block9;
                }
                case '\u00d6': {
                    ret.append("Oe");
                    continue block9;
                }
                case '\u00dc': {
                    ret.append("Ue");
                    continue block9;
                }
                case '\u00df': {
                    ret.append("ss");
                    continue block9;
                }
                default: {
                    ret.append(c);
                }
            }
        }
        return ret.toString();
    }

    public static String escape(String src, char ... escapedChars) {
        char escape = '\\';
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            for (char eC : escapedChars) {
                if (eC != c) continue;
                ret.append(escape);
                break;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String normalize(String s) {
        if (s == null || s.trim().length() == 0) {
            return s;
        }
        s = s.trim();
        StringBuilder ret = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                ret.append(c);
                continue;
            }
            ret.append('_');
        }
        return ret.toString();
    }

    private StringUtils() {
    }

    public static boolean isEmpty(String src) {
        return src == null || src.trim().length() == 0;
    }

    public static List<String> toStringList(List<?> list) {
        ArrayList<String> ret = new ArrayList<String>(list.size());
        for (Object el : list) {
            ret.add(el.toString());
        }
        return ret;
    }

    public static String trimString(String value, String delimiter, int maxSize) {
        int i;
        String rez = new String(value);
        if (rez.length() > maxSize && (i = rez.lastIndexOf(delimiter, maxSize)) != -1) {
            rez = rez.substring(0, i).concat("...");
        }
        return rez;
    }

    private static class StringPair {
        private String first;
        private String second;

        StringPair(String aFirst, String aSecond) {
            this.first = aFirst;
            this.second = aSecond;
        }

        StringPair() {
            this(null, null);
        }

        public String getFirst() {
            return this.first;
        }

        public String getSecond() {
            return this.second;
        }
    }
}

